<?php defined( 'ABSPATH' ) or exit( -1 );
/**
 * Recent Posts widgets
 * @package Bravisthemes
 */

class Patholab_Package_Type_Widget extends WP_Widget
{
    function __construct()
    {
        parent::__construct(
            'pxl_package_type',
            esc_html__( '* Pxl Package Type', 'patholab' ),
            array(
                'description' => esc_html__( 'Show Package Type Terms.', 'patholab' ),
                'customize_selective_refresh' => true,
            )
        );
    }

    function widget( $args, $instance )
    {
        global $wp, $wp_query;  
        extract( $args );
        $title = apply_filters( 'widget_title', $instance[ 'title' ] );
        $package_type = $instance[ 'package_type' ];
        $package_types = explode(",", $package_type);
    
        echo wp_kses_post($before_widget);

        if( $title ) {
            echo ''.$before_title . $title . $after_title;
        }

        $args = array('post_type' => 'package','taxonomy' => 'package-type');
        $terms = get_terms( $args );
         
        if ( is_post_type_archive( 'package' ) || is_tax( 'package-type' )  ) {
            $base_url = get_post_type_archive_link('package');
        } else {
            $base_url = get_permalink();
        }
        $current_url = $base_url;

        if( isset($_GET['filter_cat']) ){
            if((int)$_GET['filter_cat'] > 0){
                $current_url = add_query_arg( array(
                    'filter_cat' => sanitize_text_field($_GET['filter_cat']),
                ), $current_url );
            }else{
                $current_url = remove_query_arg( 'filter_cat' );
            }
        }
        if( isset($_GET['per-page']) ){
            $current_url = add_query_arg( array(
                'per-page' => sanitize_text_field($_GET['per-page']),
            ), $current_url );
        }
        if ( '' === get_option( 'permalink_structure' ) ) {
            $current_url = remove_query_arg( array( 'page', 'paged', 'package-page' ), $current_url );
        } else {
            $current_url = preg_replace( '%\/page/[0-9]+%', '', $current_url );
        } 
        
        ?>
        <ul>
            <?php
                foreach ($package_types as $p_type) {
                    foreach($terms as $term) {
                        if($p_type === $term->name) {
                            $term_link = get_term_link( $term );
                            $posts = get_posts(array(
                                'post_type' => 'package',
                                'posts_per_page'      => -1,
                                'tax_query' => array(
                                    array(
                                        'taxonomy' => 'package-type',
                                        'field' => 'term_id',
                                        'terms' => $term->term_id
                                    )
                                ))
                            );

                            $post_count = count($posts);

                            $current_filter = isset( $_GET[ 'filter_type_id' ] ) ? explode( ',', $_GET[ 'filter_type_id' ] ) : array();
                            $current_filter = array_map( 'intval', $current_filter );

                            if ( ! in_array( $term->term_id, $current_filter ) ) {
                                $current_filter[] = $term->term_id;
                            }
 
                            $chosen_terms = [];

                            if ( ! empty( $_GET[ 'filter_type_id' ] ) ) {
                                $chosen_terms = array_map( 'intval', explode( ',', $_GET[ 'filter_type_id' ] ) );
                            }

                            foreach ( $current_filter as $key => $value ) {

                                if ( in_array( $term->term_id, $chosen_terms ) && $value === $term->term_id ) {
                                    unset( $current_filter[ $key ] );
                                }
                            }
 
                            if ( ! empty( $current_filter ) ) {
                                $current_url = add_query_arg( array(
                                    'filter_type_id' => implode( ',', $current_filter ),
                                ), $current_url );
                            }else{
                                $current_url = remove_query_arg( 'filter_type_id' );
                            }

                            $chosen_class = '';
                            if ( in_array( $term->term_id, $chosen_terms )){
                                $chosen_class = 'chosen';
                            }
                             
                            echo '<li class="pxl-packate-type-item '.$chosen_class.'"><a href="' . esc_url( $current_url ) . '" data-type-id="' . $term->term_id . '">' . $term->name . '</a><span class="count">('.$post_count.')</span></li>';
                        }
                    }
                }
            ?>
        </ul>
        <?php 
        echo wp_kses_post($after_widget);
          
    }

    function update( $new_instance, $old_instance )
    {
        $instance = $old_instance;

        $instance[ 'title' ] = strip_tags( $new_instance[ 'title' ] );
        $instance['package_type'] = !empty($new_instance['package_type']) ? implode(",",$new_instance['package_type']) : 0;
        return $instance;

    }

    function form( $instance )
    {
       
        $title = isset($instance[ 'title' ]) ? $instance[ 'title' ] : 'Type Group';
        $instance['package_type'] = !empty($instance['package_type']) ? explode(",",$instance['package_type']) : array();
 
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'patholab' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
        <label for="<?php echo esc_attr($this->get_field_id( 'package_type' )); ?>"><?php esc_html_e( 'Select Package type you want to show:','patholab' ); ?></label><br />
            <?php $args = array(
                    'post_type' => 'package',
                    'taxonomy' => 'package-type',
                );
                $terms = get_terms( $args );
             
             foreach( $terms as $id => $name ) { 
                $checked = "";
                if(in_array($name->name,$instance['package_type'])){
                    $checked = "checked='checked'";
                }
            ?>
                <input type="checkbox" class="checkbox" id="<?php echo esc_attr($this->get_field_id('package_type')); ?>" name="<?php echo esc_attr($this->get_field_name('package_type[]')); ?>" value="<?php echo esc_attr($name->name); ?>"  <?php echo esc_attr($checked); ?>/>
                <label for="<?php echo esc_attr($this->get_field_id('package_type')); ?>"><?php echo esc_html($name->name); ?></label><br />
            <?php } ?>
        </p>
   
        <?php
    }
}
add_action( 'widgets_init', 'patholab_register_package_type_widget' );
function patholab_register_package_type_widget(){
    if(function_exists('pxl_register_wp_widget')){
        pxl_register_wp_widget( 'Patholab_Package_Type_Widget' );
    }
}