<?php
/**
 * @package Bravisthemes
 */
?>
<?php 
    $thumbnail = get_the_post_thumbnail($post->ID, 'patholab-archive');
    $thumbnail_url = get_the_post_thumbnail_url($post->ID, 'patholab-archive');

    $package_icon_type = get_post_meta(get_the_ID(), 'package_icon_type', true);
    $package_icon_font = get_post_meta(get_the_ID(), 'package_icon_font', true);
    $package_icon_img = get_post_meta(get_the_ID(), 'package_icon_img', true);
    $package_external_link = get_post_meta(get_the_ID(), 'package_external_link', true);
    $list_info = get_post_meta($post->ID, 'list_info', true);

    $bg_img = !empty($thumbnail_url) ? 'style="background-image: url('. esc_url($thumbnail_url).');"' : '';
?>
<article id="pxl-post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="pxl-item--inner clearfix">
        <div class="pxl-image-feature">
            <div class="image-feature-main">
                <?php echo wp_kses_post( $thumbnail );?>    
            </div>
            
            <div class="bg-image" <?php echo ''.$bg_img; ?>></div>
            <div class="bg-mask"></div>
            <?php if($package_icon_type == 'image' && !empty( $package_icon_img )) : 
                $icon_img = pxl_get_image_by_size( array(
                    'attach_id'  => $package_icon_img['id'],
                    'thumb_size' => 'full',
                ));
                $icon_thumbnail = $icon_img['thumbnail'];
                ?>
                <div class="pxl-item--icon">
                    <div class="inner-icon">
                        <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                            <?php echo wp_kses_post($icon_thumbnail); ?>
                        </a>
                    </div>
                </div>
            <?php endif; ?>
            <?php if($package_icon_type == 'icon' && !empty($package_icon_font)) : ?>
                <div class="pxl-item--icon">
                    <div class="inner-icon">
                        <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                            <i class="<?php echo esc_attr($package_icon_font); ?>"></i>
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <h3 class="pxl-item--title">
            <a href="<?php echo esc_url(get_permalink( get_the_ID() )) ?>">
                <?php echo get_the_title(get_the_ID()); ?>
            </a>
        </h3>
        <div class="pxl-item--content">
            <?php patholab()->blog->get_excerpt();?>
        </div>
        <?php if(!empty($list_info)) { ?>
            <ul class="pxl-list-row-info">
            <?php foreach ($list_info as $list_meta): ?>
                <li>
                    <i class="icomoon icomoon-patholab-check"></i>
                    <span><?php pxl_print_html($list_meta); ?></span>
                </li>
            <?php endforeach;?>
            </ul>
        <?php } ?>
        <div class="wp-buttons">
            <a class="btn btn-showmore" href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                <span>
                    <?php if(!empty($button_text)) {
                        echo esc_attr($button_text);
                    } else {
                        echo esc_html__('Book Now', 'patholab');
                    } ?>
                </span>
            </a>
            <a class="btn btn-icon" href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                <i class="icomoon icomoon-patholab-right"></i>
            </a>
        </div>
    </div>
</article>
