<?php
add_action( 'pxl_taxonomy_meta_register', 'patholab_tax_options_register' );

function patholab_tax_options_register( $metabox ) {
    $package_type_group = patholab()->get_theme_opt('package_type_group', []);
 
    $package_type_group_opt = [];
    if( !empty( $package_type_group)){
    	foreach ($package_type_group as $key => $value) {
			$package_type_group_opt[$value] = $value;
		}	
    }
	$panels = [
		'package-category' => [ //taxonomy
			'opt_name'            => 'tax_package_option',
			'display_name'        => esc_html__( 'Patholab Settings', 'patholab' ),
			'show_options_object' => false,
			'sections'  => [
				'tax_package_settings' => [
					'title'  => esc_html__( 'Patholab Settings', 'patholab' ),
					'icon'   => 'el el-refresh',
					'fields' => array(
						array(
				            'id'       => 'tax_package_icon',
				            'type'     => 'pxl_iconpicker',
				            'title'    => esc_html__('Icon Font', 'patholab'),
				        ),
						array(
                            'id'       => 'fix_redux_value',
                            'type'     => 'select',
                            'title'    => esc_html__('Fix value (test)', 'patholab'),
                            'options'  => [
                                ''   => esc_html__('Default', 'patholab'),
                                'fixed'    => esc_html__('Fixed', 'patholab'),
                            ],
                            'class' => 'redux-field-meta-hidden',
                            'default'  => '',
                        )
					)
				]
			]
		],  
	];
 
	$metabox->add_meta_data( $panels );
}
 