<?php 
/**
 * Actions Hook for the theme
 *
 * @package Bravisthemes
 */
add_action('after_setup_theme', 'patholab_setup');
function patholab_setup(){

    //Set the content width in pixels, based on the theme's design and stylesheet.
    $GLOBALS['content_width'] = apply_filters( 'patholab_content_width', 1200 );

    // Make theme available for translation.
    load_theme_textdomain( 'patholab', get_template_directory() . '/languages' );

    // Custom Header
    add_theme_support( 'custom-header' );

    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );

    // Let WordPress manage the document title.
    add_theme_support( 'title-tag' );

    // Enable support for Post Thumbnails on posts and pages.
    add_theme_support( 'post-thumbnails' );

    set_post_thumbnail_size( 1170, 710 );

    // This theme uses wp_nav_menu() in one location.
    register_nav_menus( array(
        'primary' => esc_html__( 'Primary', 'patholab' ),
    ) );

    // Add theme support for selective refresh for widgets.
    add_theme_support( 'customize-selective-refresh-widgets' );

    // Add support for core custom logo.
    add_theme_support( 'custom-logo', array(
        'height'      => 250,
        'width'       => 250,
        'flex-width'  => true,
        'flex-height' => true,
    ) );

    add_theme_support( 'post-formats', array(
        'video',
        'audio',
        'gallery',
        'quote',
        'link',
    ) );

    // Enable support for Post Thumbnails on posts and pages.
    add_theme_support('post-thumbnails');
    add_image_size( 'patholab-thumb-small', 105, 82, true );
    add_image_size( 'patholab-thumb-nav', 600, 600, true );
    add_image_size( 'patholab-thumb-xs', 120, 104, true );
    add_image_size( 'patholab-post', 970, 593, true );
    add_image_size( 'patholab-archive', 885, 593, true );
    add_image_size( 'patholab-thumb-nav-widget', 636, 400, true );

    add_theme_support( 'woocommerce' );
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
    remove_theme_support('widgets-block-editor');

}

/**
 * Register Widgets Position.
 */
add_action( 'widgets_init', 'patholab_widgets_position' );
function patholab_widgets_position() {
	register_sidebar( array(
		'name'          => esc_html__( 'Blog Sidebar', 'patholab' ),
		'id'            => 'sidebar-blog',
		'before_widget' => '<section id="%1$s" class="widget %2$s"><div class="widget-content">',
		'after_widget'  => '</div></section>',
		'before_title'  => '<h2 class="widget-title"><span>',
		'after_title'   => '</span></h2>',
	) );
    register_sidebar( array(
        'name'          => esc_html__( 'Package Sidebar', 'patholab' ),
        'id'            => 'sidebar-package',
        'description'   => esc_html__( 'Add widgets here.', 'patholab' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s"><div class="widget-content">',
        'after_widget'  => '</div></section>',
        'before_title'  => '<h2 class="widget-title"><span>',
        'after_title'   => '</span><span></span></h2>',
    ) );
	if (class_exists('ReduxFramework')) {
		register_sidebar( array(
			'name'          => esc_html__( 'Page Sidebar', 'patholab' ),
			'id'            => 'sidebar-page',
			'before_widget' => '<section id="%1$s" class="widget %2$s"><div class="widget-content">',
			'after_widget'  => '</div></section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		) );
	}

	if ( class_exists( 'Woocommerce' ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Shop Sidebar', 'patholab' ),
			'id'            => 'sidebar-shop',
			'before_widget' => '<section id="%1$s" class="widget %2$s"><div class="widget-content">',
			'after_widget'  => '</div></section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		) );
	}
}

/**
 * Enqueue Styles Scripts : Front-End
 */
add_action( 'wp_enqueue_scripts', 'patholab_scripts' );
function patholab_scripts() {  
    $patholab_version = wp_get_theme( get_template() );
    /* Popup Libs */
    wp_enqueue_style( 'jquery-ui', get_template_directory_uri() . '/assets/css/jquery-ui.css', array(), '1.0.0' );
    wp_enqueue_style('magnific-popup', get_template_directory_uri() . '/assets/css/libs/magnific-popup.css', array(), '1.1.0');
    wp_enqueue_script( 'magnific-popup', get_template_directory_uri() . '/assets/js/libs/magnific-popup.min.js', array( 'jquery' ), '1.1.0', true );
    wp_enqueue_style('wow-animate', get_template_directory_uri() . '/assets/css/libs/animate.min.css', array(), '1.1.0');
    wp_enqueue_script( 'wow-animate', get_template_directory_uri() . '/assets/js/libs/wow.min.js', array( 'jquery' ), '1.0.0', true );
    wp_enqueue_script( 'jquery-ui-slider' );
    
    /* Parallax Libs */
    wp_register_script( 'stellar-parallax', get_template_directory_uri() . '/assets/js/libs/stellar-parallax.min.js', array( 'jquery' ), '0.6.2', true );

    wp_enqueue_script( 'gsap-lib', get_template_directory_uri() . '/assets/js/libs/gsap.min.js', array( 'jquery' ), '1.0.0', true );
    /* Icons Lib - CSS */
    wp_enqueue_style('icofont', get_template_directory_uri() . '/assets/fonts/icofont/css/icofont.css', array(), $patholab_version->get( 'Version' ));
    /* Icons Lib - CSS */
    wp_enqueue_style('icomoon', get_template_directory_uri() . '/assets/fonts/icomoon/css/icomoon.css' , array(), $patholab_version->get( 'Version' ));
    /* Counter Effect */
    wp_register_script( 'pxl-counter-slide', get_template_directory_uri() . '/assets/js/libs/counter-slide.min.js', array( 'jquery' ), '1.0.0', true );
    /* Nice Select */
    wp_enqueue_script( 'nice-select', get_template_directory_uri() . '/assets/js/libs/nice-select.min.js', array( 'jquery' ), 'all', true );
	wp_enqueue_style( 'pxl-caseicon', get_template_directory_uri() . '/assets/css/caseicon.css', array(), $patholab_version->get( 'Version' ) );
    wp_enqueue_style( 'pxl-grid', get_template_directory_uri() . '/assets/css/grid.css', array(), $patholab_version->get( 'Version' ) );
	wp_enqueue_style( 'pxl-style', get_template_directory_uri() . '/assets/css/style.css', array(), $patholab_version->get( 'Version' ) );
	wp_add_inline_style( 'pxl-style', patholab_inline_styles() );
    wp_enqueue_style( 'pxl-base', get_template_directory_uri() . '/style.css', array(), $patholab_version->get( 'Version' ) );
    wp_enqueue_style( 'pxl-google-fonts', patholab_fonts_url(), array(), null );
	wp_enqueue_script( 'pxl-main', get_template_directory_uri() . '/assets/js/theme.js', array( 'jquery' ), $patholab_version->get( 'Version' ), true );
    wp_enqueue_script( 'pxl-woocommerce', get_template_directory_uri() . '/woocommerce/woocommerce.js', array( 'jquery' ), $patholab_version->get( 'Version' ), true );
    wp_localize_script( 'pxl-main', 'main_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
    do_action( 'patholab_scripts');
}

/**
 * Enqueue Styles Scripts : Back-End
 */
add_action('admin_enqueue_scripts', 'patholab_admin_style');
function patholab_admin_style() {
    $theme = wp_get_theme( get_template() );
    wp_enqueue_style( 'patholab-admin-style', get_template_directory_uri() . '/assets/css/admin.css', array(), $theme->get( 'Version' ) );
    wp_enqueue_style('icofont', get_template_directory_uri() . '/assets/fonts/icofont/css/icofont.css');
    wp_enqueue_style('icomoon', get_template_directory_uri() . '/assets/fonts/icomoon/css/icomoon.css');
    wp_enqueue_script( 'admin-widget', get_template_directory_uri() . '/inc/admin/assets/js/widget.js', array( 'jquery' ), '1.0.0', true );
}

add_action( 'elementor/editor/before_enqueue_scripts', function() {
    wp_enqueue_style( 'admin-icofont', get_template_directory_uri() . '/assets/fonts/icofont/css/icofont.css');
    wp_enqueue_style('elementor-icomoon', get_template_directory_uri() . '/assets/fonts/icomoon/css/icomoon.css');
    wp_enqueue_style( 'patholab-admin-style', get_template_directory_uri() . '/assets/css/admin.css');
} );


/* Favicon */
add_action('wp_head', 'patholab_site_favicon');
function patholab_site_favicon(){
    $favicon = patholab()->get_theme_opt( 'favicon' );
    if(!empty($favicon['url']))
        echo '<link rel="icon" type="image/png" href="'.esc_url($favicon['url']).'"/>';
}

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
add_action( 'wp_head', 'patholab_pingback_header' );
function patholab_pingback_header() {
    if ( is_singular() && pings_open() )
    {
        echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
    }
}
 
add_action( 'elementor/preview/enqueue_styles', 'patholab_add_editor_preview_style' );
function patholab_add_editor_preview_style() {
    wp_add_inline_style( 'editor-preview', patholab_editor_preview_inline_styles() );
}
function patholab_editor_preview_inline_styles(){
    $theme_colors = patholab_configs('theme_colors');
    ob_start();
        echo '.elementor-edit-area-active{';
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
        echo '}';
    return ob_get_clean();
}

add_action( 'pxl_anchor_target', 'patholab_hook_anchor_templates_hidden_panel');
function patholab_hook_anchor_templates_hidden_panel(){

    $hidden_templates = patholab_get_templates_slug('hidden-panel');
    if(empty($hidden_templates)) return;

    foreach ($hidden_templates as $slug => $values){
        $args = [
            'slug' => $slug,
            'post_id' => $values['post_id'],
            'position' => !empty($values['position']) ? $values['position'] : 'custom-pos'
        ];
        if( did_action('pxl_anchor_target_hidden_panel_'.$values['post_id']) <= 0){  
            //can be assign from here: do_action( 'pxl_anchor_target_hidden_panel_'.$slug);
            do_action( 'pxl_anchor_target_hidden_panel_'.$values['post_id'], $args );  
        }
    } 
} 

function patholab_hook_anchor_hidden_panel($args){  
    ?>
    <div class="pxl-hidden-template pxl-hidden-template-<?php echo esc_attr($args['post_id'])?> pos-<?php echo esc_attr($args['position']) ?>">
        <div class="pxl-hidden-template-wrap">
            <div class="pxl-panel-content custom_scroll">
                <span class="pxl-close" title="<?php echo esc_attr__( 'Close', 'patholab' ) ?>"></span>
               <?php echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( (int)$args['post_id']); ?>
            </div>
        </div>
    </div> 
    <?php    
}
 
function patholab_hook_anchor_custom(){
    return;
}

/* Search Popup */
if(!function_exists('patholab_hook_anchor_search')){
    function patholab_hook_anchor_search(){ ?>
        <div id="pxl-search-popup">
            <div class="pxl-item--conent">
                <form role="search" method="get" action="<?php echo esc_url(home_url( '/' )); ?>">
                    <input type="text" placeholder="<?php esc_attr_e('Start Typing here...', 'patholab'); ?>" name="s" class="search-field" />
                    <button type="submit" class="search-submit rm-style-default">
                        <i class="icofont icofont-search-1"></i>
                    </button>
                </form>
                <div class="pxl-item--close pxl-close"></div>
            </div>
        </div>
    <?php }
}       
/* Cart Sidebar */
if(!function_exists('patholab_hook_anchor_cart')){
    function patholab_hook_anchor_cart(){ ?>
        <div class="pxl-hidden-template pxl-side-cart pos-right">
            <div class="pxl-hidden-template-wrap">
                <div class="pxl-panel-header">
                    <div class="panel-header-inner">
                        <span class="pxl-title h3"><?php echo esc_html__( 'Cart', 'patholab' ) ?><span class="widget_cart_counter">(<?php echo sprintf (_n( '%d item', '%d items', WC()->cart->cart_contents_count, 'patholab' ), WC()->cart->cart_contents_count ); ?>)</span></span>
                        <span class="pxl-close" title="<?php echo esc_attr__( 'Close', 'patholab' ) ?>"></span>
                    </div>
                </div>
                <div class="pxl-panel-content widget_shopping_cart custom_scroll">
                    <div class="widget_shopping_cart_content">
                        <?php woocommerce_mini_cart(); ?>
                    </div>
                </div>
            </div>
        </div> 
        
    <?php }
}      

add_action('pre_get_posts', 'patholab_custom_post_output');
function patholab_custom_post_output( $query ){
    if ( !is_admin() && $query->is_main_query() && ( is_post_type_archive( 'package' ) || is_tax( 'package-type' ) )) {
        $package_per_page = (int)patholab()->get_theme_opt('package_per_page', '9');
        if( isset($_GET['per-page']) )
            $package_per_page = sanitize_text_field($_GET['per-page']);
 
        $query->set( 'posts_per_page', $package_per_page );

        if ( isset( $_GET['filter_type_id'] ) ) {  
            $package_type = array_filter( array_map( 'absint', explode( ',', $_GET['filter_type_id'] ) ) );  

            $taxquery = array(
                array(
                    'taxonomy' => 'package-type',
                    'field' => 'term_id',
                    'terms' => $package_type,
                    'operator'=> 'IN'
                )
            );
            $query->set( 'tax_query', $taxquery );
        }
        if ( isset( $_GET['filter_cat'] ) && (int)sanitize_text_field($_GET['filter_cat']) > 0 ) { 
            $package_category = (int)sanitize_text_field($_GET['filter_cat']);
            $taxcatquery = array(
                array(
                    'taxonomy' => 'package-category',
                    'field' => 'term_id',
                    'terms' => [$package_category],
                    'operator'=> 'IN'
                )
            );
            $query->set( 'tax_query', $taxcatquery );
        }

        if ( isset( $_GET['package-page'] ) ) {
            $pxl_paged = intval( sanitize_text_field( $_GET['package-page'] ) );
            if($pxl_paged > 1){
                $query->set( 'paged', $pxl_paged );
            }
        }
         
    }
}
