<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_list_process',
        'title' => esc_html__('Process List Pxl', 'patholab' ),
        'icon' => 'eicon-table-of-contents',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array( 
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'patholab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'patholab' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'patholab' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_list_process/img-layout/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name'     => 'content_section',
                    'label'    => esc_html__( 'Content', 'patholab' ),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name' => 'list',
                            'label' => esc_html__('List Content Extra', 'patholab'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name'     => 'item_label',
                                    'label'    => esc_html__('Item Label', 'patholab'),
                                    'type'     => 'text',
                                    'label_block' => true,
                                    'default'  => ''
                                ),
                                array(
                                    'name'     => 'item_content',
                                    'label'    => esc_html__('Item Content', 'patholab'),
                                    'type'     => 'textarea',
                                    'label_block' => true,
                                    'default'  => ''
                                ),
                            ),
                            'title_field' => '{{{ item_label }}}',
                        ),
                    )
                ),  
                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'patholab'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'max_width',
                            'label' => esc_html__( 'Layout Max Width', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'description' => esc_html__( 'Enter number.', 'patholab' ),
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process-list .content-inner' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'item_width',
                            'label' => esc_html__( 'Width Type', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'width-item-50' => esc_html__( '50%', 'patholab'),
                                'width-item-100' => esc_html__( '100%', 'patholab'),
                            ],
                            'default' => 'width-item-100',
                        ),
                        array(
                            'name' => 'bg_box_number',
                            'label' => esc_html__('Background Number', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process-list .item-number' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'number_color',
                            'label' => esc_html__('Number Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process-list .item-number' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'label_color',
                            'label' => esc_html__('Label Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process-list label' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'label_typography',
                            'label' => esc_html__('Label Typography', 'patholab' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-process-list label',
                        ),
                        array(
                            'name' => 'text_color',
                            'label' => esc_html__('Content Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-process-list .item-text' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'link_typography',
                            'label' => esc_html__('Content Typography', 'patholab' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-process-list .item-text',
                        ),
                    ),
                ),
            ),
        ),
    ),
    patholab_get_class_widget_path()
);