<?php 
if ( ! empty( $settings['team_link']['url'] ) ) {
    $widget->add_render_attribute( 'team_link', 'href', $settings['team_link']['url'] );

    if ( $settings['team_link']['is_external'] ) {
        $widget->add_render_attribute( 'team_link', 'target', '_blank' );
    }

    if ( $settings['team_link']['nofollow'] ) {
        $widget->add_render_attribute( 'team_link', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-team-single pxl-team-single2 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <?php if ( !empty($settings['image']['id']) ) : ?>
            <div class="pxl-item--image">
                <?php if ( ! empty( $settings['team_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'team_link' )); ?>><?php }?>
                    <?php 
                        $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '120x120 ';
                        $img  = pxl_get_image_by_size( array(
                            'attach_id'  => $settings['image']['id'],
                            'thumb_size' => $image_size,
                        ) );
                        $thumbnail    = $img['thumbnail'];
                    echo pxl_print_html($thumbnail); ?>
                <?php if ( ! empty( $settings['team_link']['url'] ) ) { ?></a><?php }?>
            </div>
        <?php endif; ?>
        <?php if(!empty($settings['position']) || !empty($settings['title']) ) { ?>
            <div class="pxl-item--meta">
                <h4 class="pxl-item--title el-empty">
                    <?php if ( ! empty( $settings['team_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'team_link' )); ?>><?php } ?>
                    <?php echo pxl_print_html($settings['title']); ?>
                    <?php if ( ! empty( $settings['team_link']['url'] ) ) { ?></a><?php } ?>
                </h4>
                <div class="pxl-item--position el-empty"><?php echo pxl_print_html($settings['position']); ?></div>
            </div>
        <?php } ?>
    </div>
</div>