<?php
if ( ! empty( $settings['phone_link']['url'] ) ) {
    $widget->add_render_attribute( 'phone_link', 'href', $settings['phone_link']['url'] );

    if ( $settings['phone_link']['is_external'] ) {
        $widget->add_render_attribute( 'phone_link', 'target', '_blank' );
    }

    if ( $settings['phone_link']['nofollow'] ) {
        $widget->add_render_attribute( 'phone_link', 'rel', 'nofollow' );
    }
} ?>
<div class="pxl-phone-call pxl-phone-call1 <?php echo esc_attr( $settings['style_box'] .' '.$settings['pxl_animate'] ); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">        
        <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
            <div class="pxl-item--icon <?php echo esc_attr( $settings['style_icon']); ?>">
                <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
            </div>
        <?php endif; ?>
        <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
            <div class="pxl-item--icon <?php echo esc_attr( $settings['style_icon']); ?>">
                <?php if ( ! empty( $settings['phone_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'phone_link' )); ?>><?php } ?>
                <?php $img_icon  = pxl_get_image_by_size( array(
                        'attach_id'  => $settings['icon_image']['id'],
                        'thumb_size' => 'full',
                    ) );
                    $thumbnail_icon    = $img_icon['thumbnail'];
                echo pxl_print_html($thumbnail_icon); ?>
                <?php if ( ! empty( $settings['phone_link']['url'] ) ) { ?></a><?php } ?>
            </div>
        <?php endif; ?>
        <div class="pxl-item--content">
            <?php if(!empty($settings['phone_label'])) { ?>
                <label class="pxl-label"><?php echo pxl_print_html($settings['phone_label']); ?></label>
            <?php } ?>
            <?php if(!empty($settings['phone_text'])) { ?>
                <div class="pxl-item--phone el-empty">
                    <?php if ( ! empty( $settings['phone_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'phone_link' )); ?>><?php } ?>
                        <?php echo pxl_print_html($settings['phone_text']); ?>
                    <?php if ( ! empty( $settings['phone_link']['url'] ) ) { ?></a><?php } ?>
                </div>
            <?php } ?>
        </div>
    </div>
</div>