<?php
	$default_settings = [
	    'list' => '',
	];
	$settings = array_merge($default_settings, $settings);
	extract($settings);
	$html_id = pxl_get_element_id($settings);
?>
<div class="pxl-package-offer <?php echo esc_attr( $settings['pxl_animate']); ?>">
	<div class="content-inner">
		<div class="content-item item-discount">
			<div class="inner-item">
				<?php if( !empty($settings['price_sale']) || !empty($settings['price']) ) { ?>
	                <span class="label-pecent">
	                    <?php $sale_amount = ($settings['price_sale'] * 100)/$settings['price'] ;?>
	                    <?php echo esc_html( number_format($sale_amount , 2, '.', '')); ?>
	                    <?php if( !empty($settings['label_sale']) ) { ?>
	                    	<span><?php echo esc_html($settings['label_sale']); ?></span>
	                    <?php } ?>
	                </span>
            	<?php } ?>
				<?php if( !empty( $settings['currency']) || !empty($settings['price_sale']) || !empty($settings['price']) ) { ?>
                    <div class="pxl-price">
                        <span class="pxl-price-sale"><?php echo esc_html($settings['currency']); ?><?php echo esc_html($settings['price_sale']); ?></span>
                        <span class="pxl-price-old"><?php echo esc_html($settings['currency']); ?><?php echo esc_html($settings['price']); ?></span>
                    </div>
                <?php } ?>
			</div>
		</div>
		<?php if(isset($settings['list']) && !empty($settings['list']) && count($settings['list'])): ?>		
			 <?php foreach ($settings['list'] as $key => $value):
                $icon_type = isset($value['icon_type']) ? $value['icon_type'] : '';
                $icon_image = isset($value['icon_image']) ? $value['icon_image'] : '';
                $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
                $widget->add_render_attribute( $icon_key, [
                    'class' => $value['pxl_icon'],
                    'aria-hidden' => 'true',
                ] );

			 	$item_label = isset($value['item_label']) ? $value['item_label'] : '';
			 	$item_content = isset($value['item_content']) ? $value['item_content'] : '';
			 	?>
			 	<?php if ( !empty( $item_label ) || !empty( $item_content )) : ?> 
	            <div class="content-item">
	            	<div class="inner-item">
		                <?php if ( $icon_type == 'icon' && ! empty( $value['pxl_icon'] ) ) : ?>
		                	<div class="pxl-icon">
		                        <?php if ( $is_new ):
		                            \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
		                        elseif(!empty($value['pxl_icon'])): ?>
		                            <i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i>
		                        <?php endif; ?>
		                	</div>
		                <?php endif; ?>
		                <?php if ( $icon_type == 'image' && !empty($icon_image['id']) ) : 
		                    $img_icon  = pxl_get_image_by_size( array(
		                        'attach_id'  => $icon_image['id'],
		                        'thumb_size' => 'full',
		                    ) );
		                    $thumbnail_icon    = $img_icon['thumbnail']; ?>
		                    <div class="pxl-icon">
			                    <?php echo pxl_print_html($thumbnail_icon); ?>
		                    </div>
		                <?php endif; ?>
		                <?php if ( !empty( $item_label ) || !empty( $item_content ) ) { ?> 
			                <div class="px-meta">
				                <?php if ( !empty( $item_label ) ) : ?> 
				                	<label class="item-label"><?php echo pxl_print_html($item_label); ?></label>
				                <?php endif; ?>
				                <?php if ( !empty( $item_content ) ) : ?> 
				                	<div class="item-text"><?php echo pxl_print_html($item_content); ?></div>
				                <?php endif; ?>
			                </div>
		                <?php } ?>
	            	</div>
	           	</div>
	           	<?php endif; ?>
		    <?php endforeach; ?>
		<?php endif; ?>
	</div>
</div>