<?php
	$default_settings = [
	    'list' => '',
	];
	$settings = array_merge($default_settings, $settings);
	extract($settings);
	$html_id = pxl_get_element_id($settings);
?>
<?php if(isset($settings['list']) && !empty($settings['list']) && count($settings['list'])): ?>
	<div class="pxl-list-iconbox <?php echo esc_attr($settings['item_style']); ?>">
		<div class="content-inner">
			 <?php foreach ($settings['list'] as $key => $value):
                $icon_type = isset($value['icon_type']) ? $value['icon_type'] : '';
                $icon_image = isset($value['icon_image']) ? $value['icon_image'] : '';
                $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
                $widget->add_render_attribute( $icon_key, [
                    'class' => $value['pxl_icon'],
                    'aria-hidden' => 'true',
                ] );

			 	$item_label = isset($value['item_label']) ? $value['item_label'] : '';
			 	$item_content = isset($value['item_content']) ? $value['item_content'] : '';
                $link_key = $widget->get_repeater_setting_key( 'icon_link', 'value', $key );
                if ( ! empty( $value['icon_link']['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $value['icon_link']['url'] );

                    if ( $value['icon_link']['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $value['icon_link']['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key );
			 	?>
			 	<?php if ( !empty( $item_label ) || !empty( $item_content )) : ?> 
	            <div class="content-item wow fadeInUp">
	            	<div class="inner-item">
		                <?php if ( $icon_type == 'icon' && ! empty( $value['pxl_icon'] ) ) : ?>
		                	<div class="pxl-icon">
			                    <a class="elementor-repeater-item-<?php echo esc_attr($value['_id']); ?>" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
			                        <?php if ( $is_new ):
			                            \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
			                        elseif(!empty($value['pxl_icon'])): ?>
			                            <i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i>
			                        <?php endif; ?>
			                    </a>
		                	</div>
		                <?php endif; ?>
		                <?php if ( $icon_type == 'image' && !empty($icon_image['id']) ) : 
		                    $img_icon  = pxl_get_image_by_size( array(
		                        'attach_id'  => $icon_image['id'],
		                        'thumb_size' => 'full',
		                    ) );
		                    $thumbnail_icon    = $img_icon['thumbnail']; ?>
		                    <div class="pxl-icon">
			                    <a <?php echo implode( ' ', [ $link_attributes ] ); ?>>
			                        <?php echo pxl_print_html($thumbnail_icon); ?>
			                    </a>
		                    </div>
		                <?php endif; ?>
		                <?php if ( !empty( $item_label ) ) : ?> 
		                	<label class="item-label"><?php echo pxl_print_html($item_label); ?></label>
		                <?php endif; ?>
		                <?php if ( !empty( $item_content ) ) : ?> 
		                	<div class="item-text"><?php echo pxl_print_html($item_content); ?></div>
		                <?php endif; ?>
	            	</div>
	           	</div>
	           	<?php endif; ?>
		    <?php endforeach; ?>
		</div>
	</div>
<?php endif; ?>