<?php
    if ( ! empty( $settings['adress_link']['url'] ) ) {
    $widget->add_render_attribute( 'adress_link', 'href', $settings['adress_link']['url'] );

    if ( $settings['adress_link']['is_external'] ) {
    $widget->add_render_attribute( 'adress_link', 'target', '_blank' );
    }
    if ( $settings['adress_link']['nofollow'] ) {
    $widget->add_render_attribute( 'adress_link', 'rel', 'nofollow' );
    }
} ?>
<div class="pxl-contact-info <?php echo esc_attr( $settings['pxl_animate'] ); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <?php if ( ! empty( $settings['title_box'] ) ) { ?>
        <<?php echo esc_attr($settings['title_tag']); ?> class="pxl-title pxl-title-box el-empty">
            <span><?php echo pxl_print_html($settings['title_box']); ?></span>
        </<?php echo esc_attr($settings['title_tag']); ?>>  
    <?php } ?>
    <div class="inner-box">
        <div class="pxl-box-adress">
            <?php if ( ! empty( $settings['adress_text'] ) ) { ?>
                <div class="pxl-title pxl-adress-title">
                    <?php echo pxl_print_html( $settings['adress_text'] ); ?>
                </div>
            <?php } ?>
            <?php if ( ! empty( $settings['adress_content'] ) ) { ?>
                <div class="pxl-adress-content">
                    <i class="caseicon caseicon-map"></i>
                    <?php if ( ! empty( $settings['adress_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'adress_link' )); ?>><?php } ?>
                        <?php echo pxl_print_html( $settings['adress_content'] ); ?>
                    <?php if ( ! empty( $settings['adress_link']['url'] ) ) { ?></a><?php } ?>
                </div>
            <?php } ?>
        </div>
        <?php if(isset($settings['row_info']) && !empty($settings['row_info']) && count($settings['row_info'])): ?>
            <div class="pxl-box-row">
                <div class="pxl-title pxl-row-title">
                    <?php echo pxl_print_html( $settings['row_title_text'] ); ?>
                </div>
                <ul class="pxl-list-row">
                    <?php
                        foreach ($settings['row_info'] as $key => $row_info):
                            $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
                            $widget->add_render_attribute( $icon_key, [
                                'class' => $row_info['pxl_icon'],
                                'aria-hidden' => 'true',
                            ] );
                            $link_key = $widget->get_repeater_setting_key( 'link', 'value', $key );
                            if ( ! empty( $row_info['link']['url'] ) ) {
                                $widget->add_render_attribute( $link_key, 'href', $row_info['link']['url'] );

                                if ( $row_info['link']['is_external'] ) {
                                    $widget->add_render_attribute( $link_key, 'target', '_blank' );
                                }

                                if ( $row_info['link']['nofollow'] ) {
                                    $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                                }
                            }
                            $link_attributes = $widget->get_render_attribute_string( $link_key );
                            ?>
                            <li>
                                <a <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                    <?php if(!empty($row_info['pxl_icon'])){
                                        \Elementor\Icons_Manager::render_icon( $row_info['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' );
                                    } ?>
                                    <span><?php echo pxl_print_html($row_info['text']); ?></span>
                                </a>
                            </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>
        <?php if ( !empty( $settings['time_title'] ) || !empty( $settings['time_content'] ) ) { ?>
            <div class="pxl-box-time">
                <div class="pxl-icon-time">
                    <i class="caseicon caseicon-time"></i>
                </div>
                <div class="pxl-time-body">
                    <?php if ( !empty( $settings['time_title'] ) ) { ?>
                        <div class="pxl-title pxl-time-title">
                            <?php echo pxl_print_html( $settings['time_title'] ); ?>
                        </div>
                    <?php } ?>
                    <?php if ( !empty( $settings['time_content'] ) ) { ?>
                        <div class="pxl-time-content">
                            <?php echo pxl_print_html( $settings['time_content'] ); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
    </div>
</div>
