<?php
    if ( ! empty( $settings['phone_link']['url'] ) ) {
    $widget->add_render_attribute( 'phone_link', 'href', $settings['phone_link']['url'] );

    if ( $settings['phone_link']['is_external'] ) {
    $widget->add_render_attribute( 'phone_link', 'target', '_blank' );
    }
    if ( $settings['phone_link']['nofollow'] ) {
    $widget->add_render_attribute( 'phone_link', 'rel', 'nofollow' );
    }
} ?>

<div class="pxl-contact-box2 <?php echo esc_attr( $settings['pxl_animate'] ); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <?php if(!empty($settings['banner_image']['id'])) : 
            $img = pxl_get_image_by_size( array(
                'attach_id'  => $settings['banner_image']['id'],
                'thumb_size' => 'full',
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <?php if(!empty($settings['banner_image']['id'])) : ?>
                <div class="pxl-item--bg  bg-image" style="background-image:url(<?php echo esc_url($settings['banner_image']['url']); ?>);"></div>
            <?php endif; ?>
        <?php endif; ?>
        <div class="pxl-item--description wow fadeInUp el-empty"><?php echo pxl_print_html($settings['desc']); ?></div>
        <div class="pxl-phone-box wow fadeInUp">
            <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
                <div class="pxl-item--icon">
                    <div class="inner-icon">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                    </div>
                </div>
            <?php endif; ?>
            <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
                <div class="pxl-item--icon">
                    <div class="inner-icon">
                        <?php $img_icon  = pxl_get_image_by_size( array(
                                'attach_id'  => $settings['icon_image']['id'],
                                'thumb_size' => 'full',
                            ) );
                            $thumbnail_icon    = $img_icon['thumbnail'];
                        echo pxl_print_html($thumbnail_icon); ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="phone-meta">
                <?php if($settings['label_phone']) { ?>
                    <label class="pxl-item--text pxl-item--label wow fadeInUp">
                        <?php echo pxl_print_html($settings['label_phone']); ?>
                    </label>
                <?php } ?>
                <?php if ( !empty( $settings['phone'] ) ) { ?>
                    <div class="pxl-item--number">
                        <?php if ( !empty( $settings['phone_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'phone_link' )); ?>><?php } ?>
                            <?php echo pxl_print_html( $settings['phone'] ); ?>
                        <?php if ( !empty( $settings['phone_link']['url'] ) ) { ?></a><?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>