<?php
/**
 * @package Bravisthemes
 */
get_header();

global $wp;

if ( is_post_type_archive( 'package' ) || is_tax( 'package-type' )  ) {
    $base_url = get_post_type_archive_link('package');
} else {
    $base_url = get_permalink();
}
$current_url = $base_url;

if( isset($_GET['filter_type_id']) ){
    $current_url = add_query_arg( array(
        'filter_type_id' => sanitize_text_field($_GET['filter_type_id']),
    ), $current_url );
}
if( isset($_GET['filter_cat']) ){
    if((int)$_GET['filter_cat'] > 0){
        $current_url = add_query_arg( array(
            'filter_cat' => sanitize_text_field($_GET['filter_cat']),
        ), $current_url );
    }else{
        $current_url = remove_query_arg( 'filter_cat' );
    }
}
if( isset($_GET['per-page']) ){
    $current_url = add_query_arg( array(
        'per-page' => sanitize_text_field($_GET['per-page']),
    ), $current_url );
}
if ( '' === get_option( 'permalink_structure' ) ) {
    $current_url = remove_query_arg( array( 'page', 'paged', 'package-page' ), $current_url );
} else {
    $current_url = preg_replace( '%\/page/[0-9]+%', '', $current_url );
}
?>
<div class="container">
    <div class="row pxl-content-wrap pxl-has-sidebar pxl-sidebar-left pxl-package-archive" >
        <div id="pxl-content-area" class="pxl-content-area pxl-content-package col-12 col-lg-9">
            <main id="pxl-content-main" class="package-main-content">
                <?php if ( have_posts() ) {
                    ?>
                    <div class="package-toolbar row">
                        <div class="package-archive-layout col-xl-3 col-lg-3 col-md-3">
                            <span class="package-layout layout-grid active">
                                <i class="icomoon icomoon-patholab-17"></i>
                            </span>
                            <span class="package-layout layout-list">
                                <i class="caseicon caseicon-list"></i>
                            </span>
                        </div>
                        <div class="package-archive-ordering col-xl-9 col-lg-9 col-md-9">
                            <div class="inner-column">
                                <div class="show-per-page" data-current-url="<?php echo esc_url($current_url)?>">
                                    <?php 
                                    $package_per_page = patholab()->get_theme_opt('package_per_page', '9');
                                    $current = isset($_GET['per-page']) ? sanitize_text_field($_GET['per-page']) : $package_per_page;
                                    $perpage = ['3', '6', '9' ,'12','15','18','21','24','27','30','33','36', '39' ,'42','45','48','51','54','57','60']; 
                                    ?>
                                    <div class="spp-inner">
                                        <label><?php esc_html_e('Show: ','patholab') ?></label>
                                        <select name="show_per_page" class="nice-select">
                                            <?php foreach($perpage as $val): 
                                                $selected = ($val == $current) ? 'selected="selected"' : '';
                                                ?>
                                                <option value="<?php echo esc_attr($val)?>" <?php echo ''.$selected ?>><?php echo esc_html($val) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="filter-cats" data-current-url="<?php echo esc_url($current_url)?>">
                                    <?php 
                                    $args = array('post_type' => 'package','taxonomy' => 'package-category');
                                    $terms = get_terms( $args );
                                    
                                    $current = isset($_GET['filter_cat']) ? sanitize_text_field($_GET['filter_cat']) : 0;
                                     
                                    ?>
                                    <div class="spp-inner">
                                        <label><?php esc_html_e('Sort by: ','patholab') ?></label>
                                        <select name="filter_cat" class="nice-select">
                                            <option value="0" <?php echo esc_attr($current) == 0 ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'نمایش همه', 'patholab' ) ?></option>
                                            <?php foreach($terms as $term): 

                                                $selected = ($term->term_id == $current) ? 'selected="selected"' : '';
                                                ?>
                                                <option value="<?php echo esc_attr($term->term_id)?>" <?php echo ''.$selected ?>><?php echo esc_html($term->name) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row package-grid">
                        <?php 
                        while ( have_posts() ) {
                            the_post();
                            echo '<div class="package-item col-12 col-sm-6 col-xl-4">';
                            get_template_part( 'template-parts/content/content', 'package' );
                            echo '</div>';
                        }
                        ?>
                    </div>
                    <?php 
                    $query = $GLOBALS['wp_query'];
                    $total_pages = $query->max_num_pages;
                    $current_page = max( 1, $query->get( 'paged', 1 ) );
                    $base  = esc_url_raw( add_query_arg( 'package-page', '%#%', $current_url ) );
                    $format  = isset( $format ) ? $format : '';
                    echo '<div class="pxl-pakage-archive-pagination">';
                        if ( $total_pages > 1 ) :
                            echo paginate_links(
                                apply_filters(
                                    'woocommerce_pagination_args',
                                    array(  
                                        'base'      => $base,
                                        'format'    => $format,
                                        'add_args'  => false,
                                        'current'   => $current_page,
                                        'total'     => $total_pages,
                                        'prev_text' => '<i class="caseicon caseicon-double-chevron-left"></i>',
                                        'next_text' => '<i class="caseicon caseicon-double-chevron-right"></i>',
                                        'type'      => 'plain',
                                        'end_size'  => 3,
                                        'mid_size'  => 3,
                                    )
                                )
                            );
                        endif; 
                    echo '</div>';
                } else {
                    get_template_part( 'template-parts/content/content', 'none' );
                } ?>
            </main>
        </div>
        <div id="pxl-sidebar-area" class="pxl-sidebar-area pxl-sidebar-package col-12 col-lg-3 pxl-sidebar-package-type">
            <div class="pxl-sidebar-sticky">
                <?php dynamic_sidebar( 'sidebar-package' ); ?>
            </div>
        </div>
    </div>
</div>
<?php get_footer();
