<?php
/**
 * @package Bravisthemes
*/
$archive_readmore_text = patholab()->get_theme_opt('archive_readmore_text', esc_html__('Read More', 'patholab'));
$archive_date = patholab()->get_theme_opt( 'archive_date', true );
$archive_excerpt_on = patholab()->get_theme_opt( 'archive_excerpt_on', true );

$img_url = '';
if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false)) {
    $img_url = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false);
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('pxl-item--archive wow fadeInUp'); ?>>
    <?php 
    if (has_post_format('quote')):
        $quote_text = get_post_meta( get_the_ID(), 'featured-quote-text', true );
        $quote_cite = get_post_meta( get_the_ID(), 'featured-quote-cite', true );
        ?>
        <div class="pxl-feature quote-inner">
            <blockquote>
                <p class="quote-text"><?php echo esc_html($quote_text);?></p>
                <?php if ( !empty($quote_cite) ) { ?>
                    <cite class="quote-cite"><?php echo esc_html($quote_cite);?></cite>
                <?php } ?>
            </blockquote>
        </div>
    <?php elseif (has_post_format('video')): ?>
        <?php 
            global $wp_embed;
            $featured_video = get_post_meta( get_the_ID(), 'featured-video-url', true );
            if (!empty($featured_video)) {
                echo '<div class="pxl-feature feature-video"><div class="inner-feature">';
                    echo do_shortcode($wp_embed->autoembed($featured_video));
                echo '</div></div>';
            }
        ?>
    <?php elseif (has_post_format('audio')): ?>
        <?php 
            global $wp_embed;
            $audio_url = get_post_meta( get_the_ID(), 'featured-audio-url', true );
            if (!empty($audio_url)) {
                echo '<div class="pxl-feature feature-audio">';
                    echo do_shortcode($wp_embed->autoembed($audio_url));
                echo '</div>';
            }
        ?>
    <?php elseif (has_post_format('link')): ?>
        <?php 
            $link_url = get_post_meta( get_the_ID(), 'featured-link-url', true );
            $link_text = get_post_meta( get_the_ID(), 'featured-link-text', true );
            if (!empty($link_url) && !empty($link_text)): ?>
                <div class="pxl-feature feature-link">
                    <div class="link-icon">
                        <a href="<?php echo esc_url( $link_url); ?>">
                            <svg version="1.1" viewBox="0 0 77.9 78.2">
                                <g>
                                    <path d="M30.2,48.1l-16,0c-5.5,0.1-10.1-4.3-10.1-9.8C4,32.7,8.4,28.1,13.9,28c0.1,0,0.2,0,0.3,0l16,0c1.1,0,2-0.9,2-2
                                        c0-1.1-0.9-2-2-2l-16,0c-7.7,0-14,6.2-14,14c0,7.7,6.2,14,14,14l16,0c1.1,0.1,2-0.8,2.1-1.9c0.1-1.1-0.8-2-1.9-2.1
                                        C30.4,48.1,30.3,48.1,30.2,48.1z"/>
                                    <path d="M77.3,38.3c0-7.7-6.2-14-14-14c0,0,0,0,0,0l-16,0c-1.1,0-2,1-1.9,2.1c0,1,0.9,1.9,1.9,1.9l16,0c5.5,0.1,9.9,4.7,9.8,10.2
                                        c-0.1,5.4-4.5,9.7-9.8,9.8l-16,0c-1.1-0.1-2,0.8-2.1,1.9c-0.1,1.1,0.8,2,1.9,2.1c0.1,0,0.1,0,0.2,0l16,0
                                        C71,52.3,77.3,46.1,77.3,38.3C77.3,38.3,77.3,38.3,77.3,38.3z"/>
                                    <path d="M18.8,38.1c0,0.5,0.2,1,0.6,1.4c0.4,0.4,0.9,0.6,1.4,0.6l36,0.1c1.1,0,2-0.9,2-2c0-1.1-0.9-2-2-2l-36-0.1
                                        C19.7,36.1,18.8,37,18.8,38.1C18.8,38.1,18.8,38.1,18.8,38.1z"/>
                                </g>
                            </svg>
                        </a>
                    </div>
                    <a class="link-text" target="_blank" href="<?php echo esc_url( $link_url); ?>"><?php echo esc_html($link_text);?></a>
                </div>
            <?php endif; ?>
    <?php elseif (has_post_format('gallery')): 
        $gallery_list = [];
        $gallery = get_post_meta( get_the_ID(), 'featured-gallery', true );
        $galleries = explode(',', $gallery);
         
        if(!empty($galleries)):
            if (!wp_script_is( 'swiper', 'enqueued' ))
                wp_enqueue_script( 'swiper');
            if (has_post_thumbnail()) {
                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'patholab-archive'); 
                $gallery_list[] = $featured_img_url;
            }
            foreach ($galleries as $gal_id) {
                $gal_image_url = wp_get_attachment_image_url( $gal_id, 'patholab-archive' );
                $gallery_list[] = $gal_image_url;
            }  
            echo '<div class="pxl-feature feature-gallery pxl-item--image">'; ?>
                <div class="inner-feature">
                    <div class="pxl-swiper-slider post-gallery-slider">
                        <div class="pxl-swiper-slider-wrap pxl-carousel-inner overflow-hidden">
                            <div class="pxl-swiper-container">
                                <div class="pxl-swiper-wrapper swiper-wrapper">
                                    <?php foreach ($gallery_list as $value): ?>
                                        <div class="pxl-swiper-slide swiper-slide">
                                            <img src="<?php echo esc_url($value)?>" alt="gallery">
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                        <div class="pxl-swiper-arrows">
                            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="icofont icofont-circled-left"></i></div>
                            <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="icofont icofont-circled-right"></i></div>
                        </div>
                    </div>
                </div>
                <?php if($archive_category) : ?>
                    <div class="pxl-item--category"><i class="caseicon caseicon-folder"></i><?php the_terms( get_the_ID(), 'category', ' ', '' ); ?></div>
                <?php endif; ?>
            <?php echo '</div>'; ?>
        <?php elseif (has_post_thumbnail()):
            $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'patholab-archive'); 
            echo '<div class="pxl-feature pxl-item--image">'; ?>
                <a href="<?php echo esc_url( get_permalink()); ?>">
                    <?php the_post_thumbnail('patholab-archive'); ?>
                </a>
            <?php echo '</div>';
        endif; ?>
    <?php else: ?>
        <?php if (has_post_thumbnail()) {
            $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'patholab-archive'); 
            echo '<div class="pxl-feature pxl-item--image">'; ?>
                <a href="<?php echo esc_url( get_permalink()); ?>">
                    <?php the_post_thumbnail('patholab-archive'); ?>
                </a>
                <?php if($archive_date) : ?>
                    <span class="item--date"><i class="caseicon caseicon-calendar-1"></i>&nbsp;<?php echo get_the_date(); ?></span>
                <?php endif; ?>
            <?php echo '</div>';
        } ?>
    <?php endif; ?>

    
    <div class="pxl-item--holder">
        <?php patholab()->blog->get_archive_meta(); ?>
        <?php if (!has_post_format('link') && !has_post_format('quote') && !has_post_format('audio')) { ?>
            <h2 class="pxl-item--title">
                <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                    <?php if(is_sticky()) { ?>
                        <i class="caseicon-check-mark"></i>
                    <?php } ?>
                    <?php the_title(); ?>
                </a>
            </h2>
            <?php if($archive_excerpt_on) : ?>
                <div class="pxl-item--excerpt">
                    <?php
                        patholab()->blog->get_excerpt();
                        wp_link_pages( array(
                            'before'      => '<div class="page-links">',
                            'after'       => '</div>',
                            'link_before' => '<span>',
                            'link_after'  => '</span>',
                        ) );
                    ?>
                </div>
            <?php endif; ?>
        <?php } ?>
        <div class="pxl-item--readmore">
            <a class="btn btn-arvhice" href="<?php echo esc_url( get_permalink()); ?>">
                <?php echo patholab_html($archive_readmore_text); ?>
                <svg width="15" height="15" viewBox="0 0 15 15" fill="none">
                  <path d="M2.04625 14.3533L0.520081 12.8271L10.9853 2.36189H1.6102V0.181641H14.6917V13.2631H12.5114V3.88806L2.04625 14.3533Z" fill="#2AD2C1"/>
                </svg>
            </a>
        </div>
    </div>
</article>