<?php
add_action( 'pxl_post_metabox_register', 'patholab_page_options_register' );
function patholab_page_options_register( $metabox ) {
	$panels = [
		'post' => [
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Settings', 'patholab' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Post Header', 'patholab' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        patholab_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'post_title' => [
					'title'  => esc_html__( 'Post Title', 'patholab' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        patholab_post_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'post_format_setting' => [
					'title'  => esc_html__( 'Post Format Settings', 'patholab' ),
					'icon'   => 'el el-indent-left',
					'fields' => array(
                        array(
                            'id'          => 'featured-video-url',
                            'type'        => 'text',
                            'title'       => esc_html__( 'Video URL', 'patholab' ),
                            'description' => esc_html__( 'Video will show when set post format is video', 'patholab' ),
                            'validate'    => 'url',
                            'msg'         => 'Url error!',
                        ),
                        array(
                            'id'          => 'featured-audio-url',
                            'type'        => 'text',
                            'title'       => esc_html__( 'Audio URL', 'patholab' ),
                            'description' => esc_html__( 'Audio that will show when set post format is audio', 'patholab' ),
                            'validate'    => 'url',
                            'msg'         => 'Url error!',
                        ),
                        array(
							'id'       => 'featured-gallery',
							'type'     => 'gallery',
							'title'    => esc_html__( 'Gallery Images ', 'patholab' ),
							'subtitle' => esc_html__( 'Upload images or add from media library.', 'patholab' )
						),
                        array(
							'id'      =>'featured-quote-text',
							'type'    => 'textarea',
							'title'   => esc_html__('Quote Text', 'patholab'),
							'default' => '',
                        ),
                        array(
                            'id'          => 'featured-quote-cite',
                            'type'        => 'text',
                            'title'       => esc_html__( 'Quote Cite', 'patholab' ),
                            'description' => esc_html__( 'Quote will show when set post format is quote', 'patholab' ),
                        ),
                        array(
							'id'          => 'featured-link-url',
							'type'        => 'text',
							'title'       => esc_html__( 'Format Link URL', 'patholab' ),
							'description' => esc_html__( 'Link will show when set post format is link', 'patholab' ),
                        ),
                        array(
                            'id'          => 'featured-link-text',
                            'type'        => 'text',
                            'title'       => esc_html__( 'Format Link Text', 'patholab' ),
                        ), 
					)
				],
				'post_settings' => [
					'title'  => esc_html__( 'Post Settings', 'patholab' ),
					'icon'   => 'el el-refresh',
					'fields' => array_merge(
						patholab_sidebar_pos_opts(['prefix' => 'post_', 'default' => true, 'default_value' => '-1']),
						array(
					        array(
					            'id'       => 'post_feature_image_on',
					            'title'    => esc_html__('Feature Image', 'patholab'),
					            'subtitle' => esc_html__('Show feature image on single post.', 'patholab'),
					            'type'     => 'switch',
					            'default'  => true,
					        ),
						),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'patholab' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
					    )
					)
				]
			]
		],
		'page' => [
			'opt_name'            => 'pxl_page_options',
			'display_name'        => esc_html__( 'Page Settings', 'patholab' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'patholab' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
		                  	array(
		                        'id'       => 'disable_header',
		                        'title'    => esc_html__('Disable', 'patholab'),
		                        'type'     => 'switch',
		                        'default'  => '0',
		                    ),
		              	),
				        patholab_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'patholab' ),
				                'options'  => patholab_get_nav_menu_slug(),
				                'default' => '',
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'patholab'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'patholab'),
				                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'patholab'),
				                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'patholab'),
				                ),
				                'default'  => '-1',
				            ),
				        )
				    )
				],
				'header_mobile' => [
					'title'  => esc_html__( 'Header Mobile', 'patholab' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        patholab_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
				                'id'       => 'pm_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'patholab' ),
				                'options'  => patholab_get_nav_menu_slug(),
				                'default' => '-1',
				            ),
					    )
				    )
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'patholab' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        patholab_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'patholab' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						patholab_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'patholab' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
							array(
					        	'id'           => 'loading_page',
					        	'type'         => 'button_set',
					        	'title'        => esc_html__( 'Loading', 'patholab' ),
					        	'options'      => array(
					        		'-1'  	   => esc_html__( 'Inherit', 'patholab' ),
					        		'bd' 	   => esc_html__( 'Builder', 'patholab' ),
					        	),
					        	'default'      => '-1',
					        ),
					        array(
					        	'id'    => 'loader_style',
					        	'type'  => 'select',
					        	'title' => esc_html__('Loader Style', 'patholab'),
					        	'options' => [
					                'style-text'           => esc_html__('Text(Default)', 'patholab'),
					                'style-experiment'      => esc_html__('Experiment', 'patholab'),
					                'style-business'       => esc_html__('Business', 'patholab'),
					        	],
					        	'default' => 'style-text',
					        	'indent' => true,
					        	'required' => array( 0 => 'loading_page', 1 => 'equals', 2 => 'bd' ),
					        ),
					        array(
					        	'id'             => 'loading_text',
					        	'type'           => 'text',
					        	'title'          => esc_html__('Loading Text', 'patholab'),
					        	'default'        => '',
					        	'desc'           => esc_html__('Enter the text displayed on load.', 'patholab'),
					        	'required'       => array( 0 => 'loader_style', 1 => 'equals', 2 => 'style-text' ),
					        	'force_output'   => true
					        ),
					        array(
					            'id'       => 'body_bg_color',
					            'type'     => 'background',
					            'title'    => esc_html__('Body Background Color', 'patholab'),
					            'output'   => array( 'background-color' => 'body' ),
					            'force_output' => true,
					            'background-image' => false,
					            'background-color' => true,
					            'background-position' => false,
					            'background-repeat' => false,
					            'background-size' => false,
					            'background-attachment' => false,
					            'transparent' => false,
					            'default'  => ''
					        ),

					    ),
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'patholab' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						array(
		                  	array(
		                        'id'       => 'disable_footer',
		                        'title'    => esc_html__('Disable', 'patholab'),
		                        'type'     => 'switch',
		                        'default'  => '0',
		                    ),
		              	),
				        patholab_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'p_footer_fixed',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Fixed', 'patholab'),
				                'options'  => array(
				                    'inherit' => esc_html__('Inherit', 'patholab'),
				                    'on' => esc_html__('On', 'patholab'),
				                    'off' => esc_html__('Off', 'patholab'),
				                ),
				                'default'  => 'inherit',
				            ),
					        array(
					            'id'       => 'bg_bg_backtotop',
					            'type'     => 'color_rgba',
					            'title'    => esc_html__( 'Back to Top Background Color', 'patholab' ),
					            'output'   => array( 'background-color' => '.pxl-scroll-top.pxl-on' ),
					            'force_output' => true,
					        ),
						)
				    )
				],
				'colors' => [
					'title'  => esc_html__( 'Colors', 'patholab' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
					            'id'          => 'primary_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Primary Color', 'patholab'),
					            'transparent' => false,
					            'default'     => ''
					        ),
					    )
				    )
				]
			]
		],
		'case' => [
			'opt_name'            => 'pxl_case_options',
			'display_name'        => esc_html__( 'Case Study Options', 'patholab' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'case_header' => [
					'title'  => esc_html__( 'General', 'patholab' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        patholab_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				    )
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'patholab' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        patholab_post_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				    )
				],
				'port_meta' => [
					'title'  => esc_html__( 'Meta', 'patholab' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
					 	array(
				            'id'          => 'client',
				            'type'        => 'text',
				            'title'       => esc_html__('Client', 'patholab'),
				            'default'     => ''
				        ),
				        array(
					        'id'          => 'date_start',
					        'type'        => 'date',
					        'title'       => esc_html__('Date Start', 'patholab')
					    ),
					)
				],
				'case_content' => [
					'title'  => esc_html__( 'Content', 'patholab' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						patholab_sidebar_pos_opts(['prefix' => 'case_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'patholab' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
					    )
					)
				],
				'case_footer' => [
					'title'  => esc_html__( 'Footer', 'patholab' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        patholab_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
			]
		],
		'service' => [
			'opt_name'            => 'pxl_service_options',
			'display_name'        => esc_html__( 'Service Settings', 'patholab' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'patholab' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
					            'id'=> 'service_external_link',
					            'type' => 'text',
					            'title' => esc_html__('External Link', 'patholab'),
					            'validate' => 'url',
					            'default' => '',
					        ),
					        array(
					            'id'       => 'service_icon_type',
					            'type'     => 'button_set',
					            'title'    => esc_html__('Icon Type', 'patholab'),
					            'options'  => array(
					                'icon'  => esc_html__('Icon', 'patholab'),
					                'image'  => esc_html__('Image', 'patholab'),
					            ),
					            'default'  => 'icon'
					        ),
					        array(
					            'id'       => 'service_icon_font',
					            'type'     => 'pxl_iconpicker',
					            'title'    => esc_html__('Icon', 'patholab'),
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'icon' ),
            					'force_output' => true
					        ),
					        array(
					            'id'       => 'service_icon_img',
					            'type'     => 'media',
					            'title'    => esc_html__('Icon Image', 'patholab'),
					            'default' => '',
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'image' ),
				            	'force_output' => true
					        ),
						    array(
						        'id'          => 'list_info',
						        'type'        => 'multi_text',
						        'title'       => esc_html__('List Info Extra', 'patholab')
						    ),
						)
				    )
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'patholab' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        patholab_post_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				    )
				],
				'service_content' => [
					'title'  => esc_html__( 'Content', 'patholab' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'patholab' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						)
					)
				],
				'service_footer' => [
					'title'  => esc_html__( 'Footer', 'patholab' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        patholab_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
			]
		],
		'package' => [
			'opt_name'            => 'pxl_package_options',
			'display_name'        => esc_html__( 'Package Options', 'patholab' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'package_header' => [
					'title'  => esc_html__( 'Header Custom', 'patholab' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        patholab_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				    )
				],

				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'patholab' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        patholab_post_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				    )
				],
				'package_meta' => [
					'title'  => esc_html__( 'Meta', 'patholab' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
						array(
				            'id'=> 'package_external_link',
				            'type' => 'text',
				            'title' => esc_html__('External Link', 'patholab'),
				            'validate' => 'url',
				            'default' => '',
				        ),
				        array(
				            'id'       => 'package_icon_type',
				            'type'     => 'button_set',
				            'title'    => esc_html__('Icon Type', 'patholab'),
				            'options'  => array(
				                'icon'  => esc_html__('Icon', 'patholab'),
				                'image'  => esc_html__('Image', 'patholab'),
				            ),
				            'default'  => 'icon'
				        ),
				        array(
				            'id'       => 'package_icon_font',
				            'type'     => 'pxl_iconpicker',
				            'title'    => esc_html__('Icon', 'patholab'),
				            'required' => array( 0 => 'package_icon_type', 1 => 'equals', 2 => 'icon' ),
        					'force_output' => true
				        ),
				        array(
				            'id'       => 'package_icon_img',
				            'type'     => 'media',
				            'title'    => esc_html__('Icon Image', 'patholab'),
				            'default' => '',
				            'required' => array( 0 => 'package_icon_type', 1 => 'equals', 2 => 'image' ),
			            	'force_output' => true
				        ),
				        array(
					        'id'          => 'day_pk',
					        'type'        => 'text',
					        'title'       => esc_html__('Report Delivery', 'patholab')
					    ),
				        array(
					        'id'          => 'number_tests',
					        'type'        => 'text',
					        'title'       => esc_html__('Number of Tests', 'patholab')
					    ),
					 	array(
				            'id'          => 'parameters',
				            'type'        => 'text',
				            'title'       => esc_html__('Parameters', 'patholab'),
				            'default'     => ''
				        ),
					    array(
					        'id'          => 'price',
					        'type'        => 'text',
					        'title'       => esc_html__('Regular price', 'patholab')
					    ),
					    array(
					        'id'          => 'price_sale',
					        'type'        => 'text',
					        'title'       => esc_html__('Sale price', 'patholab')
					    ),
					    array(
					        'id'          => 'currency',
					        'type'        => 'text',
					        'title'       => esc_html__('Currency price (Defualt $)', 'patholab')
					    ),
					    array(
					        'id'          => 'list_info',
					        'type'        => 'multi_text',
					        'title'       => esc_html__('List Info Extra', 'patholab')
					    ),
					)
				],

				'package_content' => [
					'title'  => esc_html__( 'Content', 'patholab' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						patholab_sidebar_pos_opts(['prefix' => 'case_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'patholab' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
					    )
					)
				],
				'package_footer' => [
					'title'  => esc_html__( 'Footer', 'patholab' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        patholab_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
			]
		],
		'product' => [
			'opt_name'            => 'pxl_product_options',
			'display_name'        => esc_html__( 'Product Options', 'patholab' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'product_header' => [
					'title'  => esc_html__( 'Header', 'patholab' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        patholab_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				    ),
				],
				'product_title' => [
					'title'  => esc_html__( 'Page Title', 'patholab' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        patholab_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'product_content' => [
					'title'  => esc_html__( 'Content', 'patholab' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						patholab_sidebar_pos_opts(['prefix' => 'product_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'patholab' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
					    )
					)
				],
				'product_footer' => [
					'title'  => esc_html__( 'Footer', 'patholab' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        patholab_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
			]
		],
		'pxl-template' => [ //post_type
			'opt_name'            => 'pxl_hidden_template_options',
			'display_name'        => esc_html__( 'Template Settings', 'patholab' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'patholab' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
						array(
							'id'    => 'template_type',
							'type'  => 'select',
							'title' => esc_html__('Type', 'patholab'),
				            'options' => [
				            	'df'       	   => esc_html__('Select Type', 'patholab'), 
								'header'       => esc_html__('Header', 'patholab'), 
								'footer'       => esc_html__('Footer', 'patholab'), 
								'mega-menu'    => esc_html__('Mega Menu', 'patholab'), 
								'page-title'   => esc_html__('Page Title', 'patholab'), 
								'tab'          => esc_html__('Tab', 'patholab'),
								'hidden-panel' => esc_html__('Hidden Panel', 'patholab'),
								'slider'       => esc_html__('Slider', 'patholab'),
				            ],
				            'default' => 'df',
				        ),
				        array(
							'id'    => 'header_type',
							'type'  => 'button_set',
							'title' => esc_html__('Header Type', 'patholab'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'patholab'), 
								'px-header--transparent'       => esc_html__('Transparent', 'patholab'),
								'px-header--left_sidebar'      => esc_html__('Left Sidebar', 'patholab'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header' ),
				        ),
				        array(
							'id'       => 'template_position',
							'type'     => 'select',
							'title'    => esc_html__('Display Position', 'patholab'),
							'options'  => [
								'left'   => esc_html__('Left Position', 'patholab'),
								'top'    => esc_html__('Top Position', 'patholab'),
								'center' => esc_html__('Center Position (popup)', 'patholab'),
								'right'  => esc_html__('Right Position', 'patholab'),
								'full'   => esc_html__('Full Screen', 'patholab'),
				            ],
							'default'  => 'left',
							'required' => [ 'template_type', '=', 'hidden-panel']
				        ),
				        array(
				            'id'          => 'hidden_panel_width',
				            'type'        => 'text',
				            'title'       => esc_html__('Hidden Panel Width', 'patholab'),
				            'subtitle'       => esc_html__('Enter number.', 'patholab'),
				            'transparent' => false,
				            'default'     => '',
				            'force_output' => true,
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),
				        array(
				            'id'          => 'header_sidebar_width',
				            'type'        => 'slider',
				            'title'       => esc_html__('Header Sidebar Width', 'patholab'),
				            "default"   => 300,
						    "min"       => 50,
						    "step"      => 1,
						    "max"       => 900,
				            'force_output' => true,
				            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'px-header--left_sidebar' ),
				        )
					),
				],
			]
		],
	];
 
	$metabox->add_meta_data( $panels );
}
 