<?php
/**
 * Filters hook for the theme
 *
 * @package Bravisthemes
 */

/* Custom Classs - Body */
function patholab_body_classes( $classes ) {   

    if (class_exists('ReduxFramework')) {
        $classes[] = ' pxl-redux-page';
    }

    $footer_fixed = patholab()->get_theme_opt('footer_fixed');
    $p_footer_fixed = patholab()->get_page_opt('p_footer_fixed');

    if($p_footer_fixed != false && $p_footer_fixed != 'inherit') {
    	$footer_fixed = $p_footer_fixed;
    }

    if(isset($footer_fixed) && $footer_fixed == 'on') {
        $classes[] = ' pxl-footer-fixed';
    }

    $header_layout = patholab()->get_opt('header_layout');
    $post_header = get_post($header_layout);
    if(!empty($post_header)) {
	    $header_type = get_post_meta( $post_header->ID, 'header_type', true );
	    if(isset($header_type)) {
	    	$classes[] = ' bd-'.$header_type.'';
	    }
    }

	$body_custom_class = patholab()->get_page_opt('body_custom_class');
	if(!empty($body_custom_class)) {
		$classes[] = $body_custom_class;
	}

    return $classes;
}
add_filter( 'body_class', 'patholab_body_classes' );

add_filter( 'pxl_server_info', 'patholab_add_server_info');
function patholab_add_server_info($infos){
  $infos = [
    'api_url' => 'https://api.bravisthemes.com/',
    'docs_url' => 'https://doc.bravisthemes.com/patholab/',
    'plugin_url' => 'https://api.bravisthemes.com/plugins/',
    'demo_url' => 'https://demo.bravisthemes.com/patholab/',
    'support_url' => 'https://bravisthemes.ticksy.com/',
    'help_url' => 'https://doc.bravisthemes.com/patholab',
    'email_support' => '',
    'video_url' => '#'
  ];
  
  return $infos;
}

/* Post Type Support Elementor*/
add_filter( 'pxl_add_cpt_support', 'patholab_add_cpt_support' );
function patholab_add_cpt_support($cpt_support) { 
	$cpt_support[] = 'service';
	$cpt_support[] = 'case';
	$cpt_support[] = 'package';
    $cpt_support[] = 'pxl-slider';
    return $cpt_support;
}

add_filter( 'pxl_support_default_cpt', 'patholab_support_default_cpt' );
function patholab_support_default_cpt($postypes){
	return $postypes; // pxl-template
}

add_filter( 'pxl_extra_post_types', 'patholab_add_post_type' );
function patholab_add_post_type( $postypes ) {

	$postypes['service'] = array(
		'status' => true,
		'item_name'  => 'Service',
		'items_name' => 'Services',
		'args'       => array(
			'menu_icon'          => 'dashicons-admin-generic',
			'rewrite'             => array(
                'slug'       => 'service',
 		 	),
		),
	); 
	
	$postypes['case'] = array(
		'status' => true,
		'item_name'  => 'Case Studie',
		'items_name' => 'Case Studies',
		'args'       => array(
			'menu_icon'          => 'dashicons-image-filter',
			'rewrite'             => array(
                'slug'       => 'case',
 		 	),
		),
	); 

	$postypes['package'] = array(
		'status' => true,
		'item_name'  => 'Package',
		'items_name' => 'Packages',
		'args'       => array(
			'menu_icon'          => 'dashicons-database-add',
			'rewrite'             => array(
                'slug'       => 'package',
 		 	),
		),
	); 
	return $postypes;
}

add_filter( 'pxl_extra_taxonomies', 'patholab_add_tax' );
function patholab_add_tax( $taxonomies ) {
	$taxonomies['service-category'] = array(
		'status'     => true,
		'post_type'  => array( 'service' ),
		'taxonomy'   => 'Service Category',
		'taxonomies' => 'Service Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'service-category'
 		 	),
		),
		'labels'     => array()
	);
	
	$taxonomies['case-category'] = array(
		'status'     => true,
		'post_type'  => array( 'case' ),
		'taxonomy'   => 'Case Category',
		'taxonomies' => 'Case Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'case-category'
 		 	),
		),
		'labels'     => array()
	);

	$taxonomies['package-category'] = array(
		'status'     => true,
		'post_type'  => array( 'package' ),
		'taxonomy'   => 'Package Category',
		'taxonomies' => 'Package Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'package-category'
 		 	),
		),
		'labels'     => array()
	);
	
	$taxonomies['package-type'] = array(
		'status'     => true,
		'post_type'  => array( 'package' ),
		'taxonomy'   => 'Package Type',
		'taxonomies' => 'Package Types',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'package-type'
 		 	),
		),
		'labels'     => array()
	);
	return $taxonomies;
}

add_filter( 'pxl_theme_builder_post_types', 'patholab_theme_builder_post_type' );
function patholab_theme_builder_post_type($postypes){
	//default are header, footer, mega-menu
	//$postypes[] = 'pxl-slider';
	return $postypes;
}

add_filter( 'pxl_theme_builder_layout_ids', 'patholab_theme_builder_layout_id' );
function patholab_theme_builder_layout_id($layout_ids){
	//default [], 
	$header_layout        = (int)patholab()->get_opt('header_layout');
	$header_mobile_layout = (int)patholab()->get_opt('header_mobile_layout');
	$header_sticky_layout = (int)patholab()->get_opt('header_sticky_layout');
	$footer_layout        = (int)patholab()->get_opt('footer_layout');
	$ptitle_layout        = (int)patholab()->get_opt('ptitle_layout');
	if( $header_layout > 0) 
		$layout_ids[] = $header_layout;
	if( $header_sticky_layout > 0) 
		$layout_ids[] = $header_sticky_layout;
	if( $header_mobile_layout > 0) 
		$layout_ids[] = $header_mobile_layout;
	if( $footer_layout > 0) 
		$layout_ids[] = $footer_layout;
	if( $ptitle_layout > 0) 
		$layout_ids[] = $ptitle_layout;
	
	return $layout_ids;
}

add_filter( 'pxl_wg_get_source_id_builder', 'patholab_wg_get_source_builder' );
function patholab_wg_get_source_builder($wg_datas){
  $wg_datas['tabs'] = ['control_name' => 'tabs', 'source_name' => 'content_template'];
  return $wg_datas;
}
 
add_filter( 'pxl_template_type_support', 'patholab_template_type_support' );
function patholab_template_type_support($type){
	//default ['header','footer','mega-menu']
	$extra_type = [
		'header-mobile' => esc_html__('Header Mobile', 'patholab'), 
        'page-title'   => esc_html__('Page Title', 'patholab'), 
        'hidden-panel' => esc_html__('Hidden Panel', 'patholab'), 
        'tab'          => esc_html__('Tab', 'patholab'), 
        'slider'          => esc_html__('Slider', 'patholab'), 
	];
	$template_type = array_merge($type,$extra_type); 
	return $template_type;
}
  

add_filter( 'get_the_archive_title', 'patholab_archive_title_remove_label' );
function patholab_archive_title_remove_label( $title ) {
	if ( is_category() ) {
		$title = single_cat_title( '', false );
	} elseif ( is_tag() ) {
		$title = single_tag_title( '', false );
	} elseif ( is_author() ) {
		$title = get_the_author();
	} elseif ( is_post_type_archive() ) {
		$title = post_type_archive_title( '', false );
	} elseif ( is_tax() ) {
		$title = single_term_title( '', false );
	} elseif ( is_home() ) {
		$title = single_post_title( '', false );
	}

	return $title;
}

add_filter( 'comment_reply_link', 'patholab_comment_reply_text' );
function patholab_comment_reply_text( $link ) {
	$link = str_replace( 'Reply', ''.esc_attr__('Reply', 'patholab').'', $link );
	return $link;
}

add_filter( 'pxl_enable_megamenu', 'patholab_enable_megamenu' );
function patholab_enable_megamenu() {
	return true;
}
add_filter( 'pxl_enable_onepage', 'patholab_enable_onepage' );
function patholab_enable_onepage() {
	return true;
}

add_filter( 'pxl_support_awesome_pro', 'patholab_support_awesome_pro' );
function patholab_support_awesome_pro() {
	return true;
}
 
add_filter( 'redux_pxl_iconpicker_field/get_icons', 'patholab_add_icons_to_pxl_iconpicker_field' );
function patholab_add_icons_to_pxl_iconpicker_field($icons){
	$custom_icons = [];
	$icons = array_merge($custom_icons, $icons);
	return $icons;
}


add_filter("pxl_mega_menu/get_icons", "patholab_add_icons_to_megamenu");
function patholab_add_icons_to_megamenu($icons){
	$custom_icons = [];
	$icons = array_merge($custom_icons, $icons);
	return $icons;
}
 

/**
 * Move comment field to bottom
 */
add_filter( 'comment_form_fields', 'patholab_comment_field_to_bottom' );
function patholab_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}


/* ------Disable Lazy loading---- */
add_filter( 'wp_lazy_loading_enabled', '__return_false' );
