<?php
// make some configs
if(!function_exists('patholab_configs')){
    function patholab_configs($value){
         
        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'patholab').' ('.patholab()->get_opt('primary_color', '#2AD2C1').')', 
                    'value' => patholab()->get_opt('primary_color', '#2AD2C1')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'patholab').' ('.patholab()->get_opt('secondary_color', '#1D2864').')', 
                    'value' => patholab()->get_opt('secondary_color', '#1D2864')
                ],
                'third'   => [
                    'title' => esc_html__('Third', 'patholab').' ('.patholab()->get_opt('third_color', '#6F7F90').')', 
                    'value' => patholab()->get_opt('third_color', '#6F7F90')
                ],
                'fourth'   => [
                    'title' => esc_html__('Fourth', 'patholab').' ('.patholab()->get_opt('fourth_color', '#00FB8A').')', 
                    'value' => patholab()->get_opt('fourth_color', '#00FB8A')
                ]
            ],
            'link' => [
                'color' => patholab()->get_opt('link_color', ['regular' => '#2AD2C1'])['regular'],
                'color-hover'   => patholab()->get_opt('link_color', ['hover' => '#2AD2C1'])['hover'],
                'color-active'  => patholab()->get_opt('link_color', ['active' => '#2AD2C1'])['active'],
            ],
            'gradient' => [
                'color-from' => patholab()->get_opt('gradient_color', ['from' => '#24B7D3'])['from'],
                'color-to' => patholab()->get_opt('gradient_color', ['to' => '#30EFAD'])['to'],
            ],
               
        ];
        return $configs[$value];
    }
}
if(!function_exists('patholab_inline_styles')) {
    function patholab_inline_styles() {  
        
        $theme_colors      = patholab_configs('theme_colors');
        $link_color        = patholab_configs('link');
        $gradient_color        = patholab_configs('gradient');
            
        ob_start();
        echo ':root{';
            
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  patholab_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            } 
            foreach ($gradient_color as $color => $value) {
                printf('--gradient-%1$s: %2$s;', $color, $value);
            } 
        echo '}';

        return ob_get_clean();
         
    }
}
 