<?php
$post_term_options = pxl_get_grid_term_options('service');
pxl_add_custom_widget(
    array(
        'name' => 'pxl_service_list',
        'title' => esc_html__('Service List Pxl', 'patholab' ),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('pxltheme-core'),
        'scripts' => [
            'imagesloaded',
            'isotope',
            'pxl-post-grid',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'patholab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'patholab' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'patholab' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_service_list/img-layout/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'patholab' ),
                                    'image' => get_template_directory_uri() . '/elements/templates/pxl_service_list/img-layout/layout2.jpg'
                                ],
                            ],
                        )
                    ),
                ),
                array(
                    'name' => 'tab_source',
                    'label' => esc_html__('Source', 'patholab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'source',
                            'label' => esc_html__('Select Categories', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT2,
                            'multiple' => true,
                            'options' => $post_term_options,
                        ),
                        array(
                            'name' => 'orderby',
                            'label' => esc_html__('Order By', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'date',
                            'options' => [
                                'date' => esc_html__('Date', 'patholab' ),
                                'ID' => esc_html__('ID', 'patholab' ),
                                'author' => esc_html__('Author', 'patholab' ),
                                'title' => esc_html__('Title', 'patholab' ),
                                'rand' => esc_html__('Random', 'patholab' ),
                            ],
                        ),
                        array(
                            'name' => 'order',
                            'label' => esc_html__('Sort Order', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'desc',
                            'options' => [
                                'desc' => esc_html__('Descending', 'patholab' ),
                                'asc' => esc_html__('Ascending', 'patholab' ),
                            ],
                        ),
                        array(
                            'name' => 'limit',
                            'label' => esc_html__('Total items', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => '4',
                        )
                    ),
                ),
                array(
                    'name' => 'tab_style_title',
                    'label' => esc_html__('Meta Style', 'patholab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'bottom_spacer',
                            'label' => esc_html__( 'Bottom Spacer', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-list .pxl-item--title + .pxl-item--title' => 'margin-top: {{SIZE}}{{UNIT}};',
                            ],
                        ),

                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-list .pxl-item--title a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'hover_style',
                            'label' => esc_html__( 'Hover Style', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'hover-defualt' => esc_html__( 'Default', 'patholab' ),
                                'hover-gradient' => esc_html__( 'Hover Gradient', 'patholab' ),
                            ],
                            'default' => 'hover-gradient',
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'title_color_hv',
                            'label' => esc_html__('Title Color Hover', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-list .pxl-item--title a:hover' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'hover_style' => ['hover-defualt'],
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'patholab' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-service-list .pxl-item--title a',
                        ),
                    ),
                ),
                patholab_widget_animation_settings()
            ),
        ),
    ),
    patholab_get_class_widget_path()
);