<?php
$pt_supports = ['post', 'service', 'case', 'package'];
pxl_add_custom_widget(
    array(
        'name' => 'pxl_post_grid',
        'title' => esc_html__('Post Grid Pxl', 'patholab' ),
        'icon' => 'eicon-posts-grid',
        'categories' => array('pxltheme-core'),
        'scripts' => [
            'imagesloaded',
            'isotope',
            'pxl-post-grid',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'tab_layout',
                    'label'    => esc_html__( 'Layout', 'patholab' ),
                    'tab'      => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'patholab' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => patholab_get_post_type_options($pt_supports),
                                'default'  => 'post'
                            ) 
                        ),
                        patholab_get_post_grid_layout($pt_supports)
                    ),
                ),
                array(
                    'name' => 'tab_source',
                    'label' => esc_html__('Source', 'patholab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'patholab' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'patholab' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'patholab' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        patholab_get_grid_term_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        patholab_get_grid_ids_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        array(
                            array(
                                'name' => 'orderby',
                                'label' => esc_html__('Order By', 'patholab' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date' => esc_html__('Date', 'patholab' ),
                                    'ID' => esc_html__('ID', 'patholab' ),
                                    'author' => esc_html__('Author', 'patholab' ),
                                    'title' => esc_html__('Title', 'patholab' ),
                                    'rand' => esc_html__('Random', 'patholab' ),
                                ],
                            ),
                            array(
                                'name' => 'order',
                                'label' => esc_html__('Sort Order', 'patholab' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'patholab' ),
                                    'asc' => esc_html__('Ascending', 'patholab' ),
                                ],
                            ),
                            array(
                                'name' => 'limit',
                                'label' => esc_html__('Total items', 'patholab' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => '6',
                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'section_box_contact',
                    'label' => esc_html__('Box Contact', 'patholab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                        'post_type' => ['package'],
                        'layout_package' => 'package-1',
                    ],
                    'controls' => array(
                        array(
                            'name' => 'box_contact',
                            'label' => esc_html__('On/Off', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'on' => esc_html__( 'On', 'patholab' ),
                                'off' => esc_html__( 'Off', 'patholab' ),
                            ],
                            'default' => 'off',
                        ),
                        array(
                            'name' => 'banner_image',
                            'label' => esc_html__('Image Background', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'box_contact' => 'on',
                            ],
                        ),
                        array(
                            'name' => 'phone_title',
                            'label' => esc_html__('Phone Title', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'rows' => 3,
                            'condition' => [
                                'box_contact' => 'on',
                            ],
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item-box-title' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'box_contact' => 'on',
                            ],
                        ),
                        array(
                            'name' => 'phone_label',
                            'label' => esc_html__('Label', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'condition' => [
                                'box_contact' => 'on',
                            ],
                        ),
                        array(
                            'name' => 'phone_text',
                            'label' => esc_html__('Phone Text', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'condition' => [
                                'box_contact' => 'on',
                            ],
                        ),
                        array(
                            'name' => 'phone_link',
                            'label' => esc_html__('Phone Link', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'condition' => [
                                'box_contact' => 'on',
                            ],
                        ),
                        array(
                            'name' => 'box_height',
                            'label' => esc_html__( 'Box Height', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'description' => esc_html__( 'Enter number.', 'patholab' ),
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .item-box-contact .pxl-item--inner' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'box_contact' => 'on',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_grid',
                    'label' => esc_html__('Grid', 'patholab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                        ),
                        array(
                            'name' => 'pxl_animate',
                            'label' => esc_html__('Case Animate', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => patholab_widget_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'filter',
                            'label' => esc_html__('Filter on Masonry', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'false',
                            'options' => [
                                'true' => esc_html__('Enable', 'patholab' ),
                                'false' => esc_html__('Disable', 'patholab' ),
                            ],
                            'condition' => [
                                'select_post_by' => 'term_selected',
                            ],
                        ),
                        array(
                            'name' => 'filter_default_title',
                            'label' => esc_html__('Filter Default Title', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('All', 'patholab' ),
                            'condition' => [
                                'filter' => 'true',
                                'select_post_by' => 'term_selected',
                            ],
                        ),
                        array(
                          'name' => 'filter_alignment',
                            'label' => esc_html__( 'Filter Alignment', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'patholab' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'patholab' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'patholab' ),
                                    'icon' => 'eicon-text-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-grid .pxl-grid-filter' => 'text-align: {{VALUE}};',
                            ],
                            'condition' => [
                                'filter' => 'true',
                                'select_post_by' => 'term_selected',
                            ],
                        ),
                        array(
                            'name' => 'icon_filter',
                            'label' => esc_html__('Filter Icon', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'icon-hidden',
                            'options' => [
                                'icon-on'     => esc_html__('Enable', 'patholab' ),
                                'icon-hidden' => esc_html__('Disable', 'patholab' ),
                            ],
                            'condition' => [
                                'filter' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'filter_color',
                            'label' => esc_html__('Filter Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl--filter-inner .filter-item' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'filter' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'filter_color_hv',
                            'label' => esc_html__('Filter Hover Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl--filter-inner .filter-item:hover, {{WRAPPER}} .pxl--filter-inner .filter-item.active, {{WRAPPER}} .pxl--filter-inner .filter-item:focus' => 'color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'filter' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'filter_typography',
                            'label' => esc_html__('Filter Typography', 'patholab' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-grid-filter .filter-item',
                            'condition' => [
                                'filter' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'pagination_type',
                            'label' => esc_html__('Pagination Type', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'false',
                            'options' => [
                                'pagination' => esc_html__('Pagination', 'patholab' ),
                                'loadmore' => esc_html__('Loadmore', 'patholab' ),
                                'false' => esc_html__('Disable', 'patholab' ),
                            ],
                        ),
                        array(
                          'name' => 'pagination_alignment',
                            'label' => esc_html__( 'Filter Alignment', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'patholab' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'patholab' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'patholab' ),
                                    'icon' => 'eicon-text-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-pagination-wrap .pxl-pagination-links' => 'justify-content: {{VALUE}};',
                            ],
                            'condition' => [
                                'pagination_type' => [ 'pagination', 'loadmore' ],
                            ],
                        ),
                        array(
                            'name' => 'pagination_style',
                            'label' => esc_html__('Pagination Style', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'pxl-pagination-style1',
                            'options' => [
                                'pxl-pagination-style1' => 'Style 1',
                                'pxl-pagination-style2' => 'Style 2',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'pagination_type', 'operator' => '==', 'value' => 'pagination'],
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'color',
                            'label' => esc_html__('Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-button .btn' => 'color: {{VALUE}};',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'case'],
                                            ['name' => 'pagination_type', 'operator' => '==', 'value' => 'loadmore'],
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'item_padding',
                            'label' => esc_html__('Item Padding', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'default' => [
                                'top' => '15',
                                'right' => '15',
                                'bottom' => '15',
                                'left' => '15'
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-grid-inner' => 'margin-top: -{{TOP}}{{UNIT}}; margin-right: -{{RIGHT}}{{UNIT}}; margin-bottom: -{{BOTTOM}}{{UNIT}}; margin-left: -{{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pxl-grid-inner .pxl-grid-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name'         => 'gap_extra',
                            'label'        => esc_html__( 'Item Gap Bottom', 'patholab' ),
                            'description'  => esc_html__( 'Add extra space at bottom of each items','patholab'),
                            'type'         => \Elementor\Controls_Manager::NUMBER,
                            'default'      => 0,
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-grid-inner .pxl-grid-item' => 'margin-bottom: {{VALUE}}px;',
                            ],
                        ),
                        array(
                            'name' => 'layout_mode',
                            'label' => esc_html__('Layout Mode', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'masonry',
                            'options' => [
                                'fitRows' => esc_html__('Fit Rows(Default)', 'patholab' ),
                                'masonry' => esc_html__('Masonry', 'patholab' ),
                            ],
                        ),
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'grid_masonry',
                            'label' => esc_html__('Grid Masonry', 'patholab'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'col_xs_m',
                                    'label' => esc_html__('Columns XS Devices', 'patholab' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '1',
                                    'options' => [
                                        '1' => '1',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'col_sm_m',
                                    'label' => esc_html__('Columns SM Devices', 'patholab' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '2',
                                    'options' => [
                                        '1' => '1',
                                        '1.5' => '2/3',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'col_md_m',
                                    'label' => esc_html__('Columns MD Devices', 'patholab' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '3',
                                    'options' => [
                                        '1' => '1',
                                        '1.5' => '2/3',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'col_lg_m',
                                    'label' => esc_html__('Columns LG Devices', 'patholab' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '3',
                                    'options' => [
                                        '1' => '1',
                                        '1.5' => '2/3',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'col_xl_m',
                                    'label' => esc_html__('Columns XL Devices', 'patholab' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'default' => '3',
                                    'options' => [
                                        '1' => '1',
                                        '1.5' => '2/3',
                                        '2' => '2',
                                        '3' => '3',
                                        '4' => '4',
                                        '6' => '6',
                                    ],
                                ),
                                array(
                                    'name' => 'img_size_m',
                                    'label' => esc_html__( 'Image Size', 'patholab' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'description' => esc_html__( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).', 'patholab' ),
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_display',
                    'label' => esc_html__('Display', 'patholab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'show_category',
                            'label' => esc_html__('Show Category', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
	                                ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => [ 'service-1' ]]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'layout_package', 'operator' => 'in', 'value' => [ 'package-3' ]]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_comment',
                            'label' => esc_html__('Show Comment', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'condition' => [
                                'post_type' => ['post'],
                                'layout_post' => 'post-1',
                            ],
                        ),
                        array(
                            'name' => 'show_tag',
                            'label' => esc_html__('Show Tag', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => 'package-3',
                            ],
                        ),
                        array(
                            'name' => 'show_date',
                            'label' => esc_html__('Show Date', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'condition' => ['post_type' => 'post']
                        ),
                        array(
                            'name' => 'show_author',
                            'label' => esc_html__('Show Author', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'condition' => ['post_type' => 'post']
                        ),

                        array(
                            'name'    => 'show_label_price',
                            'label'   => esc_html__('Show Label Price', 'patholab' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'true',
                            'options' => [
                                'true'  => esc_html__('Enable', 'patholab' ),
                                'false' => esc_html__('Disable', 'patholab' ),
                            ],
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => ['package-3', 'package-4'],
                            ],
                        ),
                        
                        array(
                            'name' => 'label_price',
                            'label' => esc_html__('Label Price', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => ['package-3', 'package-4'],
                                'show_label_price' => 'true',
                            ],
                        ),
                        array(
                            'name'    => 'show_label_suffix',
                            'label'   => esc_html__('Show Percent Label', 'patholab' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'true',
                            'options' => [
                                'true'  => esc_html__('Enable', 'patholab' ),
                                'false' => esc_html__('Disable', 'patholab' ),
                            ],
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => ['package-4'],
                            ],
                        ),
                        
                        array(
                            'name' => 'label_suffix',
                            'label' => esc_html__('Percent Label', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => [ 'package-4' ],
                                'show_label_suffix' => 'true',
                            ],
                        ),
                        array(
                            'name'    => 'show_label_day',
                            'label'   => esc_html__('Show Label Day', 'patholab' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'true',
                            'options' => [
                                'true'  => esc_html__('Enable', 'patholab' ),
                                'false' => esc_html__('Disable', 'patholab' ),
                            ],
                            'condition' => [
                                'post_type'      => ['package'],
                                'layout_package' => 'package-3',
                            ],
                        ),
                        array(
                            'name' => 'label_day',
                            'label' => esc_html__('Label Day', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => 'package-3',
                                'show_label_day' => 'true',
                            ],
                        ),
                        array(
                            'name'    => 'show_label_category',
                            'label'   => esc_html__('Show Label Category', 'patholab' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'true',
                            'options' => [
                                'true'  => esc_html__('Enable', 'patholab' ),
                                'false' => esc_html__('Disable', 'patholab' ),
                            ],
                            'condition' => [
                                'post_type'      => ['package'],
                                'layout_package' => 'package-3',
                            ],
                        ),
                        array(
                            'name' => 'label_checkcategory',
                            'label' => esc_html__('Label Check Category', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => 'package-3',
                                'show_label_category' => 'true',
                            ],
                        ),

                        array(
                            'name'    => 'show_label_test',
                            'label'   => esc_html__('Show Label Test', 'patholab' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'true',
                            'options' => [
                                'true'  => esc_html__('Enable', 'patholab' ),
                                'false' => esc_html__('Disable', 'patholab' ),
                            ],
                            'condition' => [
                                'post_type'      => ['package'],
                                'layout_package' => ['package-2', 'package-4'],
                            ],
                        ),
                        array(
                            'name' => 'label_test',
                            'label' => esc_html__('Label Test', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => ['package-2', 'package-4'],
                                'show_label_test' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'show_button',
                            'label' => esc_html__('Show Button Readmore', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1', 'service-2']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'layout_package', 'operator' => 'in', 'value' => ['package-1', 'package-2', 'package-3', 'package-4']]
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'button_text',
                            'label' => esc_html__('Button Text', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                                            ['name' => 'show_button', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'layout_package', 'operator' => 'in', 'value' => ['package-1', 'package-2', 'package-3', 'package-4']],
                                            ['name' => 'show_button', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'button_text2',
                            'label' => esc_html__('Button Text 2', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'layout_package', 'operator' => 'in', 'value' => ['package-4']],
                                            ['name' => 'show_button', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_excerpt',
                            'label' => esc_html__('Show Excerpt', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => [ 'post-4' ] ],
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1', 'service-2', 'service-3']]
                                        ],
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'num_words',
                            'label' => esc_html__('Number of Words', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 35,
                            'separator' => 'after',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-4']],
                                            ['name' => 'show_excerpt', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1', 'service-2']],
                                            ['name' => 'show_excerpt', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'show_excerpt', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'style_display',
                            'label' => esc_html__('Item Display', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'item-block' => 'Block',
                                'item-inline-block' => 'Inline-Block',
                            ],
                            'default' => 'item-block',
                            'condition' => ['post_type' => 'post']
                        ),
                        array(
                            'name' => 'style_box',
                            'label' => esc_html__('Item Style', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'item-style1' => 'Style1',
                                'item-style2' => 'Style2',
                            ],
                            'default' => 'item-style1',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-2']],
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'layout_package', 'operator' => 'in', 'value' => ['package-3']],
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'color_type',
                            'label' => esc_html__('Color Type', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'item-normal' => 'Normal',
                                'item-gradient' => 'Gradient',
                            ],
                            'default' => 'item-normal',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1', 'service-2']],
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'layout_package', 'operator' => 'in', 'value' => ['package-2','package-3']],
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'bg_item_color',
                            'label' => esc_html__('Background Item Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-grid .pxl-item--inner' => 'background-color: {{VALUE}};',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'layout_package', 'operator' => 'in', 'value' => ['package-3']],
                                        ]
                                    ],
                                ],
                            ]
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_style_title',
                    'label' => esc_html__('Title', 'patholab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'post_title_typography',
                            'label' => esc_html__('Typography', 'patholab' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-grid .pxl-item--title',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1', 'post-2']],
                                            ['name' => 'show_excerpt', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1', 'service-2']],
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                        ]
                                    ],
                                ],
                            ]
                        ),
                    ),
                ),
            ),
        ),
    ),
    patholab_get_class_widget_path()
);