<?php
$pt_supports = ['post', 'service', 'case', 'package'];
pxl_add_custom_widget(
    array(
        'name' => 'pxl_post_carousel',
        'title' => esc_html__('Post Carousel Pxl', 'patholab' ),
        'icon' => 'eicon-posts-carousel',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'swiper',
            'pxl-swiper',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'patholab' ),
                    'tab'      => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'patholab' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => patholab_get_post_type_options($pt_supports),
                                'default'  => 'post'
                            ) 
                        ),
                        patholab_get_post_carousel_layout($pt_supports)
                    ),
                ),
                array(
                    'name' => 'section_source',
                    'label' => esc_html__('Source', 'patholab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'patholab' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'patholab' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'patholab' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        patholab_get_grid_term_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        patholab_get_grid_ids_by_post_type($pt_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        array(
                            array(
                                'name' => 'orderby',
                                'label' => esc_html__('Order By', 'patholab' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date' => esc_html__('Date', 'patholab' ),
                                    'ID' => esc_html__('ID', 'patholab' ),
                                    'author' => esc_html__('Author', 'patholab' ),
                                    'title' => esc_html__('Title', 'patholab' ),
                                    'rand' => esc_html__('Random', 'patholab' ),
                                ],
                            ),
                            array(
                                'name' => 'order',
                                'label' => esc_html__('Sort Order', 'patholab' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'patholab' ),
                                    'asc' => esc_html__('Ascending', 'patholab' ),
                                ],
                            ),
                            array(
                                'name' => 'limit',
                                'label' => esc_html__('Total items', 'patholab' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => '6',
                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'section_carousel',
                    'label' => esc_html__('Carousel', 'patholab'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'pxl_animate',
                            'label' => esc_html__('Patholab Animate', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => patholab_widget_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_xxl',
                            'label' => esc_html__('Columns XXL Devices', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'inherit',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),

                        array(
                            'name' => 'slides_to_scroll',
                            'label' => esc_html__('Slides to scroll', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'item_padding',
                            'label' => esc_html__('Item Padding', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'default' => [
                                'top' => '15',
                                'right' => '15',
                                'bottom' => '15',
                                'left' => '15'
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-container' => 'margin-top: -{{TOP}}{{UNIT}}; margin-right: -{{RIGHT}}{{UNIT}}; margin-bottom: -{{BOTTOM}}{{UNIT}}; margin-left: -{{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pxl-swiper-container .pxl-swiper-slide' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'arrows',
                            'label' => esc_html__('Show Arrows', 'patholab'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'arrows_position',
                            'label' => esc_html__('Arrows Position', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'arrows-bottom',
                            'options' => [
                                'arrows-top' => 'Top',
                                'arrows-middle' => 'Middle',
                                'arrows-bottom' => 'Bottom',
                            ],
                            'condition' => [
                                'arrows' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'content_align_arrows',
                            'label' => esc_html__('Arrows align', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'patholab' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'patholab' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'patholab' ),
                                    'icon' => 'eicon-text-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .grap-arrows' => 'justify-content: {{VALUE}};',
                            ],
                            'condition' => [
                                'arrows_position' => ['arrows-top', 'arrows-bottom'],
                                'arrows' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'pagination',
                            'label' => esc_html__('Show Pagination', 'patholab'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'pagination_type',
                            'label' => esc_html__('Pagination Type', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'bullets',
                            'options' => [
                                'bullets' => 'Bullets',
                                'fraction' => 'Fraction',
                            ],
                            'condition' => [
                                'pagination' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'content_align_bullets',
                            'label' => esc_html__('Bullets align', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'patholab' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'patholab' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'patholab' ),
                                    'icon' => 'eicon-text-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-dots' => 'justify-content: {{VALUE}};',
                            ],
                            'condition' => [
                                'pagination_type' => 'bullets',
                                'pagination' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'pause_on_hover',
                            'label' => esc_html__('Pause on Hover', 'patholab'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'autoplay',
                            'label' => esc_html__('Autoplay', 'patholab'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'autoplay_speed',
                            'label' => esc_html__('Autoplay Speed', 'patholab'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 5000,
                            'condition' => [
                                'autoplay' => 'false'
                            ]
                        ),
                        array(
                            'name' => 'infinite',
                            'label' => esc_html__('Infinite Loop', 'patholab'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'speed',
                            'label' => esc_html__('Animation Speed', 'patholab'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 500,
                        ),
                    ),
                ),
                array(
                    'name' => 'section_display',
                    'label' => esc_html__('Display', 'patholab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                        ),
                        array(
                            'name' => 'show_comment',
                            'label' => esc_html__('Show Comment', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'condition' => [
                                'post_type' => ['post'],
                                'layout_post' => 'post-1',
                            ],
                        ),
                        array(
                            'name' => 'show_category',
                            'label' => esc_html__('Show Category', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ],
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1', 'service-2', 'service-3' ]]
                                        ]
                                    ]
                                ],
                            ]
                        ),

                        array(
                            'name' => 'show_date',
                            'label' => esc_html__('Show Date', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_author',
                            'label' => esc_html__('Show Author', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'condition' => [
                                'post_type' => ['post'],
                                'layout_post' => 'post-1',
                            ],
                        ),
                        array(
                            'name' => 'show_button',
                            'label' => esc_html__('Show Button Readmore', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1', 'post-2']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1']]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'button_text',
                            'label' => esc_html__('Button Readmore Text', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1', 'post-2']],
                                            ['name' => 'show_button', 'operator' => '==', 'value' => 'true'],
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1']]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name'    => 'show_label_price',
                            'label'   => esc_html__('Show Label Price', 'patholab' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'true',
                            'options' => [
                                'true'  => esc_html__('Enable', 'patholab' ),
                                'false' => esc_html__('Disable', 'patholab' ),
                            ],
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => ['package-3', 'package-4'],
                            ],
                        ),
                        
                        array(
                            'name' => 'label_price',
                            'label' => esc_html__('Label Price', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => ['package-3', 'package-4'],
                                'show_label_price' => 'true',
                            ],
                        ),
                        array(
                            'name'    => 'show_label_suffix',
                            'label'   => esc_html__('Show Percent Label', 'patholab' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'true',
                            'options' => [
                                'true'  => esc_html__('Enable', 'patholab' ),
                                'false' => esc_html__('Disable', 'patholab' ),
                            ],
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => ['package-4'],
                            ],
                        ),
                        
                        array(
                            'name' => 'label_suffix',
                            'label' => esc_html__('Percent Label', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => [ 'package-4' ],
                                'show_label_suffix' => 'true',
                            ],
                        ),
                        array(
                            'name'    => 'show_label_day',
                            'label'   => esc_html__('Show Label Day', 'patholab' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'true',
                            'options' => [
                                'true'  => esc_html__('Enable', 'patholab' ),
                                'false' => esc_html__('Disable', 'patholab' ),
                            ],
                            'condition' => [
                                'post_type'      => ['package'],
                                'layout_package' => 'package-3',
                            ],
                        ),
                        array(
                            'name' => 'label_day',
                            'label' => esc_html__('Label Day', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => 'package-3',
                                'show_label_day' => 'true',
                            ],
                        ),
                        array(
                            'name'    => 'show_label_category',
                            'label'   => esc_html__('Show Label Category', 'patholab' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'true',
                            'options' => [
                                'true'  => esc_html__('Enable', 'patholab' ),
                                'false' => esc_html__('Disable', 'patholab' ),
                            ],
                            'condition' => [
                                'post_type'      => ['package'],
                                'layout_package' => 'package-3',
                            ],
                        ),
                        array(
                            'name' => 'label_checkcategory',
                            'label' => esc_html__('Label Check Category', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => 'package-3',
                                'show_label_category' => 'true',
                            ],
                        ),

                        array(
                            'name'    => 'show_label_test',
                            'label'   => esc_html__('Show Label Test', 'patholab' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'default' => 'true',
                            'options' => [
                                'true'  => esc_html__('Enable', 'patholab' ),
                                'false' => esc_html__('Disable', 'patholab' ),
                            ],
                            'condition' => [
                                'post_type'      => ['package'],
                                'layout_package' => ['package-2', 'package-4'],
                            ],
                        ),
                        array(
                            'name' => 'label_test',
                            'label' => esc_html__('Label Test', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'post_type' => ['package'],
                                'layout_package' => ['package-2', 'package-4'],
                                'show_label_test' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'show_excerpt',
                            'label' => esc_html__('Show Excerpt', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1', 'post-2', 'post-3']]
                                        ],
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1', 'service-2', 'service-3']]
                                        ],
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'layout_package', 'operator' => 'in', 'value' => ['package-1', 'package-2']]
                                        ],
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'num_words',
                            'label' => esc_html__('Number of Words', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 25,
                            'separator' => 'after',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1', 'post-2', 'post-3']],
                                            ['name' => 'show_excerpt', 'operator' => 'in', 'value' => ['true']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1', 'service-2', 'service-3']],
                                            ['name' => 'show_excerpt', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'layout_package', 'operator' => 'in', 'value' => ['package-1', 'package-2']],
                                            ['name' => 'show_excerpt', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ],
                                ],
                            ]
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_style_general',
                    'label' => esc_html__('General', 'patholab' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'style_box',
                            'label' => esc_html__('Item Style', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'item-style1' => 'Style1',
                                'item-style2' => 'Style2',
                            ],
                            'default' => 'item-style1',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-2']],
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'layout_package', 'operator' => 'in', 'value' => ['package-3']],
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'color_type',
                            'label' => esc_html__('Color Type', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'item-normal' => 'Normal',
                                'item-gradient' => 'Gradient',
                            ],
                            'default' => 'item-normal',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1', 'service-2']],
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'layout_package', 'operator' => 'in', 'value' => ['package-2','package-3']],
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'bg_item_color',
                            'label' => esc_html__('Background Item Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-grid .pxl-item--inner' => 'background-color: {{VALUE}};',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'package'],
                                            ['name' => 'layout_package', 'operator' => 'in', 'value' => ['package-3']],
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'post_item_border',
                            'label' => esc_html__('Item Border Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-carousel .pxl-item--inner' => 'border-color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-post-carousel .pxl-meta-bottom' => 'border-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => ['post'],
                                'layout_post' => ['post-1', 'post-2', 'post-3'],
                            ],
                        ),
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__('Icon Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item--icon a i, {{WRAPPER}} .pxl-item--icon i' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'icon_color_hv',
                            'label' => esc_html__('Icon Color Hover', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item--icon:hover a i, {{WRAPPER}} .pxl-item--icon:hover i' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'post_title_color',
                            'label' => esc_html__('Title Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item--inner .pxl-item--title a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'post_title_color_hv',
                            'label' => esc_html__('Title Color Hover', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item--inner .pxl-item--title a:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'post_title_typography',
                            'label' => esc_html__('Typography', 'patholab' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-item--inner .pxl-item--title',
                        ),
                        array(
                            'name' => 'post_excerpt_color',
                            'label' => esc_html__('Excerpt Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item--inner .pxl-item--content' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => ['post'],
                                'layout_post' => ['post-1', 'post-2'],
                            ],
                        ),
                        array(
                            'name' => 'style_date',
                            'label' => esc_html__('Date Style', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'date-color' => 'Default',
                                'date-gradient' => 'Gradient',
                            ],
                            'default' => 'date-gradient',
                            'condition' => [
                                'post_type' => ['post'],
                                'layout_post' => ['post-1', 'post-2'],
                            ]
                        ),
                        array(
                            'name' => 'post_comment_color',
                            'label' => esc_html__('Comment Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-meta-bottom .item--comment a' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => ['post'],
                                'layout_post' => ['post-1'],
                            ],
                        ),
                        array(
                            'name' => 'post_comment_color_hv',
                            'label' => esc_html__('Comment Color Hover', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-post-carousel .pxl-meta-bottom .item--comment a:hover' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => ['post'],
                                'layout_post' => ['post-1'],
                            ],
                        ),
                        array(
                            'name' => 'dottesd_color',
                            'label' => esc_html__('Dottesd Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item--meta li::after' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => ['post'],
                                'layout_post' => ['post-1', 'post-2'],
                            ],
                        ),
                        array(
                            'name' => 'button_color',
                            'label' => esc_html__('Button Color', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item--inner .btn-showmore' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => ['post'],
                                'layout_post' => ['post-1', 'post-2'],
                            ],
                        ),
                        array(
                            'name' => 'button_color_hover',
                            'label' => esc_html__('Button Color Hover', 'patholab' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-item--inner .btn-showmore:hover' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'post_type' => ['post'],
                                'layout_post' => ['post-1', 'post-2'],
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    patholab_get_class_widget_path()
);