<?php 
    if ( ! empty( $settings['team_link']['url'] ) ) {
        $widget->add_render_attribute( 'team_link', 'href', $settings['team_link']['url'] );

        if ( $settings['team_link']['is_external'] ) {
            $widget->add_render_attribute( 'team_link', 'target', '_blank' );
        }

        if ( $settings['team_link']['nofollow'] ) {
            $widget->add_render_attribute( 'team_link', 'rel', 'nofollow' );
        }
    }
?>
<div class="pxl-team-single pxl-team-single1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <?php if ( !empty($settings['image']['id']) ) : ?>
            <div class="pxl-team-avatar">
                <?php if(!empty($settings['image_icon1']['id'])) : 
                    $img_icon1 = pxl_get_image_by_size( array(
                        'attach_id'  => $settings['image_icon1']['id'],
                        'thumb_size' => 'full',
                        'class' => 'no-lazyload'
                    ));
                    $thumbnail_icon1 = $img_icon1['thumbnail'];
                    ?>
                    <div class="box-icon box-icon-1">
                        <?php echo pxl_print_html($thumbnail_icon1); ?>
                    </div>
                <?php endif; ?>
                <?php if(!empty($settings['image_icon2']['id'])) : 
                    $img_icon2 = pxl_get_image_by_size( array(
                        'attach_id'  => $settings['image_icon2']['id'],
                        'thumb_size' => 'full',
                        'class' => 'no-lazyload'
                    ));
                    $thumbnail_icon2 = $img_icon2['thumbnail'];
                    ?>
                    <div class="box-icon box-icon-2">
                        <?php echo pxl_print_html($thumbnail_icon2); ?>
                    </div>
                <?php endif; ?>
                <div class="pxl-item--meta">
                    <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
                        <div class="pxl-item--icon">
                            <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                        </div>
                    <?php endif; ?>
                    <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
                        <div class="pxl-item--icon">
                            <?php $img_icon  = pxl_get_image_by_size( array(
                                    'attach_id'  => $settings['icon_image']['id'],
                                    'thumb_size' => 'full',
                                ) );
                                $thumbnail_icon    = $img_icon['thumbnail'];
                            echo pxl_print_html($thumbnail_icon); ?>
                        </div>
                    <?php endif; ?>
                    <?php if( !empty($settings['title_box']) || !empty($settings['sub_title']) ) { ?>
                        <div class="pxl-meta">
                            <?php if(!empty($settings['title_box'])) { ?>
                                <h4 class="pxl-box--title el-empty"><?php echo pxl_print_html($settings['title_box']); ?></h4>
                            <?php } ?>
                            <?php if(!empty($settings['sub_title'])) { ?>
                                <div class="pxl-sub-title el-empty"><?php echo pxl_print_html($settings['sub_title']); ?></div>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
                <?php 
                    $image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full';
                    $img  = pxl_get_image_by_size( array(
                        'attach_id'  => $settings['image']['id'],
                        'thumb_size' => $image_size,
                    ) );
                    $thumbnail    = $img['thumbnail'];
                echo pxl_print_html($thumbnail); ?>
            </div>
            <?php if( !empty($settings['title']) || !empty($settings['position']) ) { ?>
                <div class="pxl-body">
                    <?php if(!empty($settings['title'])) { ?>
                        <h4 class="pxl-item--title el-empty">
                            <?php if ( ! empty( $settings['team_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'team_link' )); ?>><?php } ?>
                                <?php echo pxl_print_html($settings['title']); ?>
                            <?php if ( ! empty( $settings['team_link']['url'] ) ) { ?></a><?php } ?>
                        </h4>
                    <?php } ?>
                    <?php if(!empty($settings['position'])) { ?>
                        <div class="pxl-item--position el-empty"><?php echo pxl_print_html($settings['position']); ?></div>
                    <?php } ?>
                </div>
            <?php } ?>
        <?php endif; ?>
    </div>
</div>