<?php
global $post;
$previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
$next     = get_adjacent_post( false, '', false );
if ( ! $next && ! $previous ) {
    return;
}
$next_post = get_next_post();
$previous_post = get_previous_post();

if ( ! empty( $settings['btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'btn_link', 'href', $settings['btn_link']['url'] );

    if ( $settings['btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
    }
    if ( $settings['btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
    }
}

if( !empty($next_post) || !empty($previous_post) ) { ?>
    <div class="pxl-pagination1">
        <?php if ( is_a( $previous_post , 'WP_Post' ) && get_the_title( $previous_post->ID ) != '') { 
            ?>
            <div class="pxl--item item--prev">
                <a class="btn-nav btn-prev" href="<?php echo esc_url(get_permalink( $previous_post->ID )); ?>">
                    <i class="icomoon icomoon-patholab-right"></i>
                </a>
            </div>
        <?php } ?>

        <div class="pxl--ttem-list">
            <?php if ( ! empty( $settings['btn_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link' )); ?>><?php } ?>
                <i class="icomoon icomoon-patholab-17"></i>
            <?php if ( ! empty( $settings['btn_link']['url'] ) ) { ?></a><?php } ?>
        </div>
        <?php if ( is_a( $next_post , 'WP_Post' ) && get_the_title( $next_post->ID ) != '') { 
            ?>
            <div class="pxl--item item--next">
                <a class="btn-nav btn-next" href="<?php echo esc_url(get_permalink( $next_post->ID )); ?>">
                    <i class="icomoon icomoon-patholab-right"></i>
                </a>
            </div>
        <?php } ?>
    </div>
<?php } ?>