<?php 
extract($settings);
if(!is_singular( 'package' )) return;
$post_id = get_the_ID();
$number_tests = get_post_meta( $post_id, 'number_tests', true );
$day_pk = get_post_meta( $post_id, 'day_pk', true);
$parameters = get_post_meta( $post_id, 'parameters', true);
$price = get_post_meta( $post_id, 'price', true);
$currency = get_post_meta( $post_id, 'currency', true);

$term_list = get_the_term_list( $post_id, 'package-category', '', ' ', '' );
$tag_list = get_the_term_list( $post_id, 'package-tag', '', ' ', '' );
$package_external_link = get_post_meta($post_id, 'package_external_link', true);

$show_button = $widget->get_setting('show_button');
$button_text = $widget->get_setting('button_text');
?>
<div class="pxl-package-info <?php echo esc_attr( $settings['pxl_animate']); ?>">
	<div class="content-inner">
		<?php if( is_singular( 'package' ) && $post_id > 0 ): ?>
			<?php if ( !is_wp_error( $term_list ) ) : ?> 
				<div class="content-item type-category wow skewIn">
					<div class="item-icon">
						<i class="icomoon icomoon-patholab-17"></i>
					</div>
					<div class="item-meta">
						<label class="lbl d-block"><?php echo esc_html__( 'Checkup Category', 'patholab' ) ?></label>
						<?php the_terms( $post_id, 'package-category', '', ' ' ); ?>
					</div>
				</div>
			<?php endif; ?>
			<?php if ( !is_wp_error( $tag_list ) ) : ?> 
				<div class="content-item type-tag wow skewIn">
					<div class="item-icon">
						<i class="icomoon icomoon-patholab-17"></i>
					</div>
					<div class="item-meta">
						<label class="lbl d-block"><?php echo esc_html__( 'Checkup Tag', 'patholab' ) ?></label>
						<?php the_terms( $post_id, 'package-tag', '', ' ' ); ?>
					</div>
				</div>
			<?php endif; ?>
			<?php if ( !empty( $day_pk ) ) : ?> 
				<div class="content-item wow skewIn">
					<div class="item-icon"> 
						<i class="icomoon icomoon-patholab-18"></i>
					</div>
					<div class="item-meta">
						<label class="lbl d-block"><?php echo esc_html__( 'Report Delivery', 'patholab' ) ?></label>
						<span class="item-text"><?php pxl_print_html($day_pk) ?></span>
					</div>
				</div>
			<?php endif; ?>
			<?php if ( !empty( $number_tests  ) ) : ?> 
				<div class="content-item wow skewIn">
					<div class="item-icon">
						<i class="icomoon icomoon-patholab-7"></i>
					</div>
					<div class="item-meta">
						<label class="lbl d-block"><?php echo esc_html__( 'Number of Tests', 'patholab' ) ?></label>
						<span class="item-text"><?php pxl_print_html($number_tests) ?></span>
					</div>
				</div>
			<?php endif; ?>
			<?php if ( !empty( $parameters  ) ) : ?> 
				<div class="content-item wow skewIn">
					<div class="item-icon">
						<i class="caseicon icomoon-patholab-list"></i>
					</div>
					<div class="item-meta">
						<label class="lbl d-block"><?php echo esc_html__( 'Parameters', 'patholab' ) ?></label>
						<span class="item-text"><?php pxl_print_html($parameters) ?></span>
					</div>
				</div>
			<?php endif; ?>
		<?php endif; ?>
		<?php if(isset($list) && !empty($list) && count($list)): 
        	foreach ($list as $key => $pxl_list): ?>
        		<?php if ( !empty( $pxl_list['item_label'] ) || !empty( $pxl_list['item_content'] ) ) : ?> 
		            <div class="content-item wow skewIn">
		            	<div class="item-icon">
		            		<i class="caseicon caseicon-check-mark"></i>
		            	</div>
		            	<div class="item-meta">
			                <?php if ( !empty( $pxl_list['item_label'] ) ) : ?> 
			                	<label class="lbl d-block"><?php pxl_print_html($pxl_list['item_label'])?></label>
			                <?php endif; ?>
			                <?php if ( !empty( $pxl_list['item_content'] ) ) : ?> 
			                	<span class="item-text"><?php pxl_print_html($pxl_list['item_content'])?></span>
			                <?php endif; ?>
			            </div>
		           </div>
	           <?php endif; ?>
	        <?php endforeach; ?>
		<?php endif; ?>
	</div>
	<?php if ( !empty($price) || !empty($currency) ) : ?> 
		<div class="content-item-full price wow skewIn">
			<label><?php echo esc_html__( 'Price:', 'patholab' ) ?></label>
			<span class="item-text-price"><?php pxl_print_html($price) ?></span>
			<span class="item-text-currency"><?php pxl_print_html($currency) ?></span>
		</div>
	<?php endif; ?>
    <?php if($settings['show_button'] == 'true') : ?>
        <a class="btn btn-showmore" href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
            <?php if(!empty($button_text)) {
                echo esc_attr($button_text);
            } else {
                echo esc_html__('Book Now', 'patholab');
            } ?>
        </a>
    <?php endif; ?>
</div>