<?php
$html_id = pxl_get_element_id($settings);
$editor_title = $widget->get_settings_for_display( 'title' );
$editor_title = $widget->parse_text_editor( $editor_title );
?>
<div class="pxl-heading">
	<div class="pxl-heading--inner">
		<?php if(!empty($settings['sub_title'])) : ?>
			<div class="pxl-item--subtitle <?php echo esc_attr( $settings['pxl_animate_sub'] ); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay_sub']); ?>ms">
				<span><?php echo esc_html($settings['sub_title']); ?></span>
			</div>
		<?php endif; ?>
		<<?php echo esc_attr($settings['title_tag']); ?> class="pxl-item--title <?php if($settings['pxl_animate'] !== 'wow letter') { echo esc_attr($settings['pxl_animate']); } ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
			<?php if($settings['source_type'] == 'text' && !empty($editor_title)) {
				if($settings['pxl_animate'] == 'wow letter') {
					$arr_str = explode(' ', $editor_title); ?>
					<span class="pxl-item--text">
			            <?php foreach ($arr_str as $index => $value) {
			                $arr_str[$index] = '<span class="pxl-text--slide"><span class="'.$settings['pxl_animate'].'">' . $value . '</span></span>';
			            }
			            $str = implode(' ', $arr_str);
			            echo wp_kses_post($str); ?>
			        </span>
				<?php } else {
					echo wp_kses_post($editor_title);
				} 
			} elseif($settings['source_type'] == 'title') {
				$titles = patholab()->page->get_title();
				pxl_print_html($titles['title']);
			}?>		
		</<?php echo esc_attr($settings['title_tag']); ?>>
		<?php if ( $settings['divider'] == 'divider-on' ) { ?>
			<svg width="33" height="7" viewBox="0 0 33 7" fill="none">
				<path d="M33 1.71875C29.7 1.71875 29.7 5.71875 26.402 5.71875C23.1 5.71875 23.1 1.71875 19.8 1.71875C16.5 1.71875 16.5 5.71875 13.201 5.71875C9.901 5.71875 9.901 1.71875 6.601 1.71875C3.301 1.71875 3.303 5.71875 0 5.71875" stroke="url(#paint0_linear_911_44929-<?php echo esc_attr($html_id) ?>" stroke-width="2"/>
				<defs>
				<linearGradient id="paint0_linear_911_44929-<?php echo esc_attr($html_id) ?>" x1="6.14673e-08" y1="3.71875" x2="33" y2="3.71875" gradientUnits="userSpaceOnUse">
				<stop stop-color="#24B7D3"/>
				<stop offset="1" stop-color="#30EFAD"/>
				</linearGradient>
				</defs>
			</svg>
		<?php } ?>
	</div>
</div>