<?php 
    if(!function_exists('patholab_get_post_grid')){
    function patholab_get_post_grid($posts = [], $settings = []){ 
        if (empty($posts) || !is_array($posts) || empty($settings) || !is_array($settings)) {
            return false;
        }
        switch ($settings['layout']) {
            case 'post-1':
                patholab_get_post_grid_layout1($posts, $settings);
                break;
            case 'post-2':
                patholab_get_post_grid_layout2($posts, $settings);
                break;
            case 'post-3':
                patholab_get_post_grid_layout3($posts, $settings);
                break;
            case 'case-1':
                patholab_get_case_grid_layout1($posts, $settings);
                break;
            case 'case-2':
                patholab_get_case_grid_layout2($posts, $settings);
                break;
            case 'service-1':
                patholab_get_service_grid_layout1($posts, $settings);
                break;
            case 'service-2':
                patholab_get_service_grid_layout2($posts, $settings);
                break;
            case 'service-3':
                patholab_get_service_grid_layout3($posts, $settings);
                break;
            case 'package-1':
                patholab_get_package_grid_layout1($posts, $settings);
                break;
            case 'package-2':
                patholab_get_package_grid_layout2($posts, $settings);
                break;
            case 'package-3':
                patholab_get_package_grid_layout3($posts, $settings);
                break;
            case 'package-4':
                patholab_get_package_grid_layout4($posts, $settings);
                break;
            default:
                return false;
                break;
        }
    }
}

// Start Post Grid
//--------------------------------------------------
function patholab_get_post_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '740x600';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            $author = get_user_by('id', $post->post_author); ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                        <div class="pxl-feature pxl-item--featured">
                            <a class="link-thumbnail" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </a>
                            <?php if($show_date == 'true') { ?>
                                <?php if($show_date == 'true'): ?>
                                    <span class="item--date">
                                        <i class="flaticon flaticon-date"></i>
                                        <?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?>
                                    </span>
                                <?php endif; ?>
                            <?php } ?>                            
                        </div>
                    <?php endif; ?>
                    <div class="pxl-item--holder">
                        <?php if( $show_date == 'true' || $show_comment == 'true' ) : ?>
                            <ul class="pxl-item--meta">
                                <?php if($show_author == 'true'): ?>
                                    <li class="item--author">
                                        <a href="<?php echo esc_url(get_author_posts_url($post->post_author, $author->user_nicename)); ?>">
                                            <i class="caseicon caseicon-user"></i>
                                            <?php echo esc_html($author->display_name); ?>
                                        </a>
                                    </li>
                                <?php endif; ?>                                
                                <?php if( $show_comment == 'true' ) { ?>
                                    <li class="item--comment">
                                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                            <i class="caseicon caseicon-comment"></i>
                                            <?php
                                                $comment_count = get_comments_number( $post->ID );
                                                if ( 1 === intval($comment_count) ) {
                                                    echo esc_html__( '1 Comment', 'patholab' );
                                                } else {
                                                    echo esc_attr( $comment_count ).' '.esc_html__('Comments', 'patholab');
                                                }
                                            ?>
                                        </a>
                                    </li>
                                <?php } ?>
                            </ul>
                        <?php endif; ?>
                        <?php if($show_category == 'true'): ?>
                            <div class="pxl-item--category">
                                <?php the_terms( $post->ID, 'post_tag', '', ' ' ); ?>
                            </div>
                        <?php endif; ?>
                        <h3 class="pxl-item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                        <?php if($show_button == 'true') : ?>
                            <a class="btn-showmore" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <span><?php if(!empty($button_text)) {
                                    echo esc_attr($button_text);
                                } else {
                                    echo esc_html__('Read More', 'patholab');
                                } ?></span>
                                <svg width="15" height="15" viewBox="0 0 15 15" fill="none">
                                  <path d="M2.04625 14.3533L0.520081 12.8271L10.9853 2.36189H1.6102V0.181641H14.6917V13.2631H12.5114V3.88806L2.04625 14.3533Z" fill="#2AD2C1"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
function patholab_get_post_grid_layout2($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '740x600';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            $author = get_user_by('id', $post->post_author); ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                        <div class="pxl-feature pxl-item--featured">
                            <a class="link-thumbnail" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </a>
                            <?php if($show_date == 'true') { ?>
                                <?php if($show_date == 'true'): ?>
                                    <span class="item--date">
                                        <i class="flaticon flaticon-date"></i>
                                        <?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?>
                                    </span>
                                <?php endif; ?>
                            <?php } ?>                            
                        </div>
                    <?php endif; ?>
                    <div class="pxl-item--holder">
                        <?php if($show_category == 'true'): ?>
                            <div class="pxl-item--category">
                                <?php the_terms( $post->ID, 'post_tag', '', ' ' ); ?>
                            </div>
                        <?php endif; ?>
                        <h3 class="pxl-item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                        <?php if($show_button == 'true') : ?>
                            <a class="btn-showmore" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <span><?php if(!empty($button_text)) {
                                    echo esc_attr($button_text);
                                } else {
                                    echo esc_html__('Read More', 'patholab');
                                } ?></span>
                                <svg width="15" height="15" viewBox="0 0 15 15" fill="none">
                                  <path d="M2.04625 14.3533L0.520081 12.8271L10.9853 2.36189H1.6102V0.181641H14.6917V13.2631H12.5114V3.88806L2.04625 14.3533Z" fill="#2AD2C1"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
function patholab_get_post_grid_layout3($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '600x380';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
                $thumbnail_url    = $img['url'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            $author = get_user_by('id', $post->post_author); ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                        <div class="pxl-feature pxl-item--featured">
                            <div class="bg-image" style="background-image: url(<?php echo wp_kses_post($thumbnail_url); ?>);"></div>
                            <a class="link-thumbnail" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </a>                           
                        </div>
                    <?php endif; ?>
                    <div class="pxl-item--body">
                        <?php if( $show_author == 'true' || $show_comment == 'true' ) : ?>
                            <ul class="pxl-item--meta">
                                <?php if($show_author == 'true'): ?>
                                    <li class="item--author">
                                        <a href="<?php echo esc_url(get_author_posts_url($post->post_author, $author->user_nicename)); ?>">
                                            <i class="caseicon caseicon-user"></i>
                                            <?php echo esc_html($author->display_name); ?>
                                        </a>
                                    </li>
                                <?php endif; ?>                                
                                <?php if( $show_comment == 'true' ) { ?>
                                    <li class="item--comment">
                                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                            <i class="caseicon-comment"></i>
                                            <?php
                                                $comment_count = get_comments_number( $post->ID );
                                                if ( 1 === intval($comment_count) ) {
                                                    echo esc_html__( '1 Comment', 'patholab' );
                                                } else {
                                                    echo esc_attr( $comment_count ).' '.esc_html__('Comments', 'patholab');
                                                }
                                            ?>
                                        </a>
                                    </li>
                                <?php } ?>
                            </ul>
                        <?php endif; ?>
                        <h3 class="pxl-item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
// End Post Grid
//--------------------------------------------------

// Start Service Grid
//--------------------------------------------------
function patholab_get_service_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '822x600';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
                $thumbnail_url    = $img['url'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } 

            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
            $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                        <div class="item--featured">
                            <div class="bg-image" style="background-image: url(<?php echo wp_kses_post($thumbnail_url); ?>);"></div>
                            <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    <div class="item-body">
                        <div class="item-meta">
                            <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                                $icon_img = pxl_get_image_by_size( array(
                                    'attach_id'  => $service_icon_img['id'],
                                    'thumb_size' => 'full',
                                ));
                                $icon_thumbnail = $icon_img['thumbnail'];
                                ?>
                                <div class="pxl-item--icon">
                                    <div class="svg-bg"></div>
                                    <div class="svg-holder"></div>
                                    <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                        <?php echo wp_kses_post($icon_thumbnail); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                                <div class="pxl-item--icon">
                                    <div class="svg-bg"></div>
                                    <div class="svg-holder"></div>
                                    <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                        <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <h3 class="pxl-item--title">
                                <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a>
                            </h3>
                        </div>
                        <?php if($show_excerpt == 'true'): ?>
                            <div class="pxl-item--content">
                                <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                            </div>
                        <?php endif; ?>

                        <?php if($show_button == 'true') : ?>
                            <a class="btn-showmore" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <?php if(!empty($button_text)) {
                                    echo esc_attr($button_text);
                                } else {
                                    echo esc_html__('Read More', 'patholab');
                                } ?>
                                <i class="icomoon icomoon-patholab-right2"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
function patholab_get_service_grid_layout2($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '822x600';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } 

            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
            $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                        $icon_img = pxl_get_image_by_size( array(
                            'attach_id'  => $service_icon_img['id'],
                            'thumb_size' => 'full',
                        ));
                        $icon_thumbnail = $icon_img['thumbnail'];
                        ?>
                        <div class="pxl-item--icon">
                            <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <?php echo wp_kses_post($icon_thumbnail); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                        <div class="pxl-item--icon">
                            <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                            </a>
                        </div>
                    <?php endif; ?>
                    <h3 class="pxl-item--title">
                        <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a>
                    </h3>
                    <?php if($show_excerpt == 'true'): ?>
                        <div class="pxl-item--content">
                            <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                        </div>
                    <?php endif; ?>

                    <?php if($show_button == 'true') : ?>
                        <a class="btn-showmore" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                            <?php if(!empty($button_text)) {
                                echo esc_attr($button_text);
                            } else {
                                echo esc_html__('Read More', 'patholab');
                            } ?>
                            <i class="icomoon icomoon-patholab-right2"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
function patholab_get_service_grid_layout3($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '822x600';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } 

            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
            $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
            $list_info = get_post_meta($post->ID, 'list_info', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <div class="bg-image" style="background-image: url(<?php echo wp_kses_post($thumbnail_url); ?>);">
                    </div>
                    <div class="bg-mask"></div>
                    <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                        $icon_img = pxl_get_image_by_size( array(
                            'attach_id'  => $service_icon_img['id'],
                            'thumb_size' => 'full',
                        ));
                        $icon_thumbnail = $icon_img['thumbnail'];
                        ?>
                        <div class="pxl-item--icon">
                            <div class="inner-icon">
                                <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <?php echo wp_kses_post($icon_thumbnail); ?>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                        <div class="pxl-item--icon">
                            <div class="inner-icon">
                                <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <h3 class="pxl-item--title">
                        <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                            <?php echo esc_html(get_the_title($post->ID)); ?>
                        </a>
                    </h3>
                    <?php if($show_excerpt == 'true'): ?>
                        <div class="pxl-item--content">
                            <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                        </div>
                    <?php endif; ?>

                    <?php if(!empty($list_info)) { ?>
                        <ul class="pxl-list-row-info">
                        <?php foreach ($list_info as $list_meta): ?>
                            <li>
                                <i class="icomoon icomoon-patholab-check"></i>
                                <span><?php pxl_print_html($list_meta); ?></span>
                            </li>
                        <?php endforeach;?>
                        </ul>
                    <?php } ?>
                    <?php if($show_button == 'true') : ?>
                        <div class="wp-buttons">
                            <a class="btn btn-showmore" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <span>
                                    <?php if(!empty($button_text)) {
                                        echo esc_attr($button_text);
                                    } else {
                                        echo esc_html__('Book Now', 'patholab');
                                    } ?>
                                </span>
                            </a>
                            <a class="btn btn-icon" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <i class="icomoon icomoon-patholab-right"></i>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
// End Portfolio Grid
//-------------------------------------

// Start Case Grid
//--------------------------------------------------
function patholab_get_case_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '800x600';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            $case_date = get_post_meta($post->ID, 'date_start', true);

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                        <div class="item--featured">
                            <?php echo wp_kses_post($thumbnail); ?>
                            <a class="btn-link" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <i class="icomoon icomoon-patholab-right2"></i>
                            </a>
                            <?php if($show_category == 'true'): ?>
                                <div class="item--category">
                                    <?php the_terms( $post->ID, 'case-category', '', ' ' ); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="item--meta">
                            <div class="item-date">
                                <?php echo date("F j, Y", strtotime($case_date)) ?>
                            </div>
                            <h3 class="pxl-item--title">
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <?php echo esc_html(get_the_title($post->ID)); ?>
                                </a>
                            </h3>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
function patholab_get_case_grid_layout2($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '520x650';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                        <div class="item--featured">
                            <a class="btn-link" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post($thumbnail); ?>    
                            </a>
                        </div>
                        <div class="item--meta">
                            <div class="inner-meta">
                                <?php if($show_category == 'true'): ?>
                                    <div class="item--category">
                                        <?php the_terms( $post->ID, 'case-category', '', ' ' ); ?>
                                    </div>
                                <?php endif; ?>
                                <h3 class="pxl-item--title">
                                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                        <?php echo esc_html(get_the_title($post->ID)); ?>
                                    </a>
                                </h3>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
// End Case Grid
//-------------------------------------

// Start Package Grid
//--------------------------------------------------
function patholab_get_package_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '822x600';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
                $thumbnail_url    = $img['url'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } 

            $package_icon_type = get_post_meta($post->ID, 'package_icon_type', true);
            $package_icon_font = get_post_meta($post->ID, 'package_icon_font', true);
            $package_icon_img = get_post_meta($post->ID, 'package_icon_img', true);
            $package_external_link = get_post_meta($post->ID, 'package_external_link', true);
            $list_info = get_post_meta($post->ID, 'list_info', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <div class="bg-image" style="background-image: url(<?php echo wp_kses_post($thumbnail_url); ?>);">
                    </div>
                    <div class="bg-mask"></div>
                    <?php if($package_icon_type == 'image' && !empty($package_icon_img)) : 
                        $icon_img = pxl_get_image_by_size( array(
                            'attach_id'  => $package_icon_img['id'],
                            'thumb_size' => 'full',
                        ));
                        $icon_thumbnail = $icon_img['thumbnail'];
                        ?>
                        <div class="pxl-item--icon">
                            <div class="inner-icon">
                                <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <?php echo wp_kses_post($icon_thumbnail); ?>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($package_icon_type == 'icon' && !empty($package_icon_font)) : ?>
                        <div class="pxl-item--icon">
                            <div class="inner-icon">
                                <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <i class="<?php echo esc_attr($package_icon_font); ?>"></i>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <h3 class="pxl-item--title">
                        <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                            <?php echo esc_html(get_the_title($post->ID)); ?>
                        </a>
                    </h3>
                    <?php if($show_excerpt == 'true'): ?>
                        <div class="pxl-item--content">
                            <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                        </div>
                    <?php endif; ?>

                    <?php if(!empty($list_info)) { ?>
                        <ul class="pxl-list-row-info">
                        <?php foreach ($list_info as $list_meta): ?>
                            <li>
                                <i class="icomoon icomoon-patholab-check"></i>
                                <span><?php pxl_print_html($list_meta); ?></span>
                            </li>
                        <?php endforeach;?>
                        </ul>
                    <?php } ?>
                    <?php if($show_button == 'true') : ?>
                        <div class="wp-buttons">
                            <a class="btn btn-showmore" href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <span>
                                    <?php if(!empty($button_text)) {
                                        echo esc_attr($button_text);
                                    } else {
                                        echo esc_html__('Book Now', 'patholab');
                                    } ?>
                                </span>
                            </a>
                            <a class="btn btn-icon" href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <i class="icomoon icomoon-patholab-right"></i>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
function patholab_get_package_grid_layout2($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '822x600';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
                $thumbnail_url    = $img['url'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } 

            $package_icon_type = get_post_meta($post->ID, 'package_icon_type', true);
            $package_icon_font = get_post_meta($post->ID, 'package_icon_font', true);
            $package_icon_img = get_post_meta($post->ID, 'package_icon_img', true);
            $package_external_link = get_post_meta($post->ID, 'package_external_link', true);
            $list_info = get_post_meta($post->ID, 'list_info', true);
            $number_tests = get_post_meta($post->ID, 'number_tests', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <div class="pxl-content-main">
                        <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                            <div class="item--featured">
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <?php echo wp_kses_post($thumbnail); ?>    
                                </a>
                            </div>
                        <?php endif; ?>
                        <div class="pxl-item-body">
                            <?php if($package_icon_type == 'image' && !empty($package_icon_img)) : 
                                $icon_img = pxl_get_image_by_size( array(
                                    'attach_id'  => $package_icon_img['id'],
                                    'thumb_size' => 'full',
                                ));
                                $icon_thumbnail = $icon_img['thumbnail'];
                                ?>
                                <div class="pxl-item--icon">
                                    <div class="bg-mask"></div>
                                    <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                        <?php echo wp_kses_post($icon_thumbnail); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <?php if($package_icon_type == 'icon' && !empty($package_icon_font)) : ?>
                                <div class="pxl-item--icon">
                                    <div class="bg-mask"></div>
                                    <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                        <i class="<?php echo esc_attr($package_icon_font); ?>"></i>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <h3 class="pxl-item--title">
                                <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <?php echo esc_html(get_the_title($post->ID)); ?>
                                </a>
                            </h3>
                            <?php if($show_excerpt == 'true'): ?>
                                <div class="pxl-content">
                                    <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                                </div>
                            <?php endif; ?>
                            <?php if(!empty($number_tests)) { ?>
                                <div class="pxl-abc">
                                    <?php if($show_label_test == 'true') { ?>
                                        <label>
                                            <?php if(!empty($label_test)) {
                                                echo esc_attr($label_test);
                                            } else {
                                                echo esc_html__('Includes', 'patholab');
                                            } ?>
                                        </label>
                                    <?php } ?>
                                    <span><?php echo esc_html($number_tests); ?></span>
                                </div>      
                            <?php } ?>
                        </div>
                    </div>
                    <div class="pxl-content-holder">
                        <div class="bg-image" style="background-image: url(<?php echo wp_kses_post($thumbnail_url); ?>);">
                        </div>
                        <?php if($package_icon_type == 'image' && !empty($package_icon_img)) : 
                            $icon_img = pxl_get_image_by_size( array(
                                'attach_id'  => $package_icon_img['id'],
                                'thumb_size' => 'full',
                            ));
                            $icon_thumbnail = $icon_img['thumbnail'];
                            ?>
                            <div class="pxl-item--icon">
                                <div class="bg-mask"></div>
                                <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <?php echo wp_kses_post($icon_thumbnail); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <?php if($package_icon_type == 'icon' && !empty($package_icon_font)) : ?>
                            <div class="pxl-item--icon">
                                <div class="bg-mask"></div>
                                <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <i class="<?php echo esc_attr($package_icon_font); ?>"></i>
                                </a>
                            </div>
                        <?php endif; ?>
                        <h3 class="pxl-item--title">
                            <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <?php echo esc_html(get_the_title($post->ID)); ?>
                            </a>
                        </h3>
                        <?php if($show_excerpt == 'true'): ?>
                            <div class="pxl-content">
                                <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                            </div>
                        <?php endif; ?>

                        <?php if(!empty($list_info)) { ?>
                            <ul class="pxl-list-row-info">
                            <?php foreach ($list_info as $list_meta): ?>
                                <li>
                                    <i class="icomoon icomoon-patholab-check"></i>
                                    <span><?php pxl_print_html($list_meta); ?></span>
                                </li>
                            <?php endforeach;?>
                            </ul>
                        <?php } ?>
                        <?php if($show_button == 'true') :?>
                            <a class="btn btn-showmore" href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <span>
                                    <?php if(!empty($button_text)) {
                                        echo esc_attr($button_text);
                                    } else {
                                        echo esc_html__('Book Now', 'patholab');
                                    } ?>
                                </span>
                                <i class="icomoon icomoon-patholab-right"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
function patholab_get_package_grid_layout3($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '822x600';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
                $thumbnail_url    = $img['url'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } 

            $package_icon_type = get_post_meta($post->ID, 'package_icon_type', true);
            $package_icon_font = get_post_meta($post->ID, 'package_icon_font', true);
            $package_icon_img = get_post_meta($post->ID, 'package_icon_img', true);
            $package_external_link = get_post_meta($post->ID, 'package_external_link', true);
            $day_pk = get_post_meta($post->ID, 'day_pk', true);
            $price = get_post_meta($post->ID, 'price', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                        <div class="item--featured">
                            <div class="bg-image" style="background-image: url(<?php echo wp_kses_post($thumbnail_url); ?>);"></div>
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post($thumbnail); ?>    
                            </a>
                        </div>
                    <?php endif; ?>
                    <div class="pxl-item-body">
                        <div class="meta-top">
                            <?php if($package_icon_type == 'image' && !empty($package_icon_img)) : 
                                $icon_img = pxl_get_image_by_size( array(
                                    'attach_id'  => $package_icon_img['id'],
                                    'thumb_size' => 'full',
                                ));
                                $icon_thumbnail = $icon_img['thumbnail'];
                                ?>
                                <div class="pxl-item--icon">
                                    <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                        <?php echo wp_kses_post($icon_thumbnail); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <?php if($package_icon_type == 'icon' && !empty($package_icon_font)) : ?>
                                <div class="pxl-item--icon">
                                    <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                        <i class="<?php echo esc_attr($package_icon_font); ?>"></i>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <div class="pxl-titles">
                                <?php if($show_tag == 'true') { ?>
                                    <div class="pxl-tag">
                                        <?php the_terms( $post->ID, 'package-type', '', ' ' ); ?>    
                                    </div>
                                <?php } ?>
                                <h3 class="pxl-item--title">
                                    <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                        <?php echo esc_html(get_the_title($post->ID)); ?>
                                    </a>
                                </h3>
                            </div>
                            <?php if(!empty($price)) { ?>
                                <div class="pxl-price">
                                    <?php if($show_label_price == 'true') { ?>
                                        <label>
                                            <?php if(!empty($label_price)) {
                                                echo esc_attr($label_price);
                                            } else {
                                                echo esc_html__('From', 'patholab');
                                            } ?>
                                        </label>
                                    <?php } ?>
                                    <span><?php echo pxl_print_html($price); ?></span>
                                </div>      
                            <?php } ?>
                        </div>
                        <div class="meta-midle">
                            <?php if($show_excerpt == 'true'): ?>
                                <div class="pxl-content">
                                    <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                                </div>
                            <?php endif; ?>
                            <?php if($show_category == 'true'): ?>
                                <div class="item--category pxl-inline-flex">
                                    <div class="item-icon">
                                        <i class="icomoon icomoon-patholab-17"></i>
                                    </div>
                                    <div class="item-meta">
                                        <?php if($show_label_category == 'true') { ?>
                                            <label>
                                                <?php if(!empty($label_checkcategory)) {
                                                    echo esc_attr($label_checkcategory);
                                                } else {
                                                    echo esc_html__('Checkup Category', 'patholab');
                                                } ?>
                                            </label>
                                        <?php } ?>
                                        <?php the_terms( $post->ID, 'package-category', '', ' ' ); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if(!empty($day_pk)) { ?>
                                <div class="pxl-abc pxl-inline-flex">
                                    <div class="item-icon">
                                        <i class="icomoon icomoon-patholab-18"></i>
                                    </div>
                                    <div class="item-meta">
                                        <?php if($show_label_day == 'true') { ?>
                                            <label>
                                                <?php if(!empty($label_day)) {
                                                    echo esc_attr($label_day);
                                                } else {
                                                    echo esc_html__('Report Delivery', 'patholab');
                                                } ?>
                                            </label>
                                        <?php } ?>
                                        <span><?php echo esc_html($day_pk); ?></span>
                                    </div>
                                </div>      
                            <?php } ?>
                        </div>
                        <?php if($show_button == 'true') : ?>
                            <a class="btn btn-showmore" href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <span>
                                    <?php if(!empty($button_text)) {
                                        echo esc_attr($button_text);
                                    } else {
                                        echo esc_html__('Book Now', 'patholab');
                                    } ?>
                                </span>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
function patholab_get_package_grid_layout4($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '822x600';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';
            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } 

            $package_icon_type = get_post_meta($post->ID, 'package_icon_type', true);
            $package_icon_font = get_post_meta($post->ID, 'package_icon_font', true);
            $package_icon_img = get_post_meta($post->ID, 'package_icon_img', true);
            $package_external_link = get_post_meta($post->ID, 'package_external_link', true);
            $list_info = get_post_meta($post->ID, 'list_info', true);
            $number_tests = get_post_meta($post->ID, 'number_tests', true);

            $price = get_post_meta($post->ID, 'price', true);
            $price_sale = get_post_meta($post->ID, 'price_sale', true);
            $currency = get_post_meta($post->ID, 'currency', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <div class="pxl-content-main">
                        <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                            <div class="item--featured">
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <?php echo wp_kses_post($thumbnail); ?>    
                                </a>
                            </div>
                        <?php endif; ?>
                        <div class="pxl-item-body">
                            <div class="pxl-item--sale">
                                <div class="bg-mask"></div>
                                <?php if($show_label_suffix == 'true') { ?>
                                    <label>
                                        <?php if(!empty($label_suffix)) {
                                            echo esc_attr($label_suffix);
                                        } else {
                                            echo esc_html__('Off', 'patholab');
                                        } ?>
                                    </label>
                                <?php } ?>
                                <span>
                                    <?php $sale_amount = ($price_sale * 100)/$price ;?>
                                    <?php echo esc_html( number_format($sale_amount , 2, '.', '')); ?>%
                                </span>
                            </div>
                            <h3 class="pxl-item--title">
                                <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <?php echo esc_html(get_the_title($post->ID)); ?>
                                </a>
                            </h3>
                            <?php if(!empty($price_sale) || !empty($price)) { ?>
                                <div class="pxl-price">
                                    <?php if($show_label_price == 'true') { ?>
                                        <label>
                                            <?php if(!empty($label_price)) {
                                                echo esc_html($label_price);
                                            } else {
                                                echo esc_html__('Price', 'patholab');
                                            } ?>
                                        </label>
                                    <?php } ?>
                                    <span class="pxl-price-sale"><?php echo esc_html($currency); ?><?php echo esc_html($price_sale); ?></span>
                                    <span class="pxl-price-old"><?php echo esc_html($currency); ?><?php echo esc_html($price); ?></span>
                                </div>
                            <?php } ?>
                            <?php if($show_excerpt == 'true'): ?>
                                <div class="pxl-content">
                                    <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                                </div>
                            <?php endif; ?>
                            <?php if(!empty($number_tests)) { ?>
                                <div class="pxl-abc">
                                    <?php if($show_label_test == 'true') { ?>
                                        <label>
                                            <?php if(!empty($label_test)) {
                                                echo esc_html($label_test);
                                            } else {
                                                echo esc_html__('Includes', 'patholab');
                                            } ?>
                                        </label>
                                    <?php } ?>
                                    <span><?php echo esc_html($number_tests); ?></span>
                                </div>      
                            <?php } ?>
                        </div>
                    </div>
                    <div class="pxl-content-holder">
                        <div class="bg-image"></div>
                        <?php if($package_icon_type == 'image' && !empty($package_icon_img)) : 
                            $icon_img = pxl_get_image_by_size( array(
                                'attach_id'  => $package_icon_img['id'],
                                'thumb_size' => 'full',
                            ));
                            $icon_thumbnail = $icon_img['thumbnail'];
                            ?>
                            <div class="pxl-item--icon">
                                <div class="bg-mask"></div>
                                <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <?php echo wp_kses_post($icon_thumbnail); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <?php if($package_icon_type == 'icon' && !empty($package_icon_font)) : ?>
                            <div class="pxl-item--icon">
                                <div class="bg-mask"></div>
                                <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <i class="<?php echo esc_attr($package_icon_font); ?>"></i>
                                </a>
                            </div>
                        <?php endif; ?>
                        <h3 class="pxl-item--title">
                            <a href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                <?php echo esc_html(get_the_title($post->ID)); ?>
                            </a>
                        </h3>
                        <?php if($show_excerpt == 'true'): ?>
                            <div class="pxl-content">
                                <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($list_info)) { ?>
                            <ul class="pxl-list-row-info">
                            <?php foreach ($list_info as $list_meta): ?>
                                <li>
                                    <i class="icomoon icomoon-patholab-check"></i>
                                    <span><?php pxl_print_html($list_meta); ?></span>
                                </li>
                            <?php endforeach;?>
                            </ul>
                        <?php } ?>
                        <?php if($show_button == 'true') { ?>
                            <div class="wp-buttom">
                                <a class="btn btn-showmore" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <span>
                                        <?php if(!empty($button_text2)) {
                                            echo esc_html($button_text2);
                                        } else {
                                            echo esc_html__('Know More', 'patholab');
                                        } ?>
                                    </span>
                                </a>
                                <a class="btn btn-showmore" href="<?php if(!empty($package_external_link)) { echo esc_url($package_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <span>
                                        <?php if(!empty($button_text)) {
                                            echo esc_html($button_text);
                                        } else {
                                            echo esc_html__('Book Now', 'patholab');
                                        } ?>
                                    </span>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
// End Package Grid
//-------------------------------------
add_action( 'wp_ajax_patholab_get_pagination_html', 'patholab_get_pagination_html' );
add_action( 'wp_ajax_nopriv_patholab_get_pagination_html', 'patholab_get_pagination_html' );
function patholab_get_pagination_html(){
    try{
        if(!isset($_POST['query_vars'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'patholab'));
        }
        $query = new WP_Query($_POST['query_vars']);
        ob_start();
        patholab()->page->get_pagination( $query,  true );
        $html = ob_get_clean();
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'patholab'),
                'data' => array(
                    'html' => $html,
                    'query_vars' => $_POST['query_vars'],
                    'post' => $query->have_posts()
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}

add_action( 'wp_ajax_patholab_load_more_product_grid', 'patholab_load_more_product_grid' );
add_action( 'wp_ajax_nopriv_patholab_load_more_product_grid', 'patholab_load_more_product_grid' );
function patholab_load_more_product_grid(){
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'patholab'));
        }
        $settings = $_POST['settings'];
        set_query_var('paged', $settings['paged']);
        $query_type         = isset($settings['query_type']) ? $settings['query_type'] : 'recent_product';
        $post_per_page      = isset($settings['limit']) ? $settings['limit'] : 8;
        $product_ids        = isset($settings['product_ids']) ? $settings['product_ids'] : '';
        $categories         = isset($settings['categories']) ? $settings['categories'] : '';
        $param_args         = isset($settings['param_args']) ? $settings['param_args'] : [];

        $col_xxl = isset($settings['col_xxl']) ? 'col-xxl-'.str_replace('.', '',12 / floatval($settings['col_xxl'])) : '';
        $col_xl = isset($settings['col_xl']) ? 'col-xl-'.str_replace('.', '',12 / floatval( $settings['col_xl'])) : '';
        $col_lg = isset($settings['col_lg']) ? 'col-lg-'.str_replace('.', '',12 / floatval( $settings['col_lg'])) : '';
        $col_md = isset($settings['col_md']) ? 'col-md-'.str_replace('.', '',12 / floatval( $settings['col_md'])) : '';
        $col_sm = isset($settings['col_sm']) ? 'col-sm-'.str_replace('.', '',12 / floatval( $settings['col_sm'])) : ''; 
        $col_xs = isset($settings['col_xs']) ? 'col-'.str_replace('.', '',12 / floatval( $settings['col_xs'])) : ''; 
 
        $item_class = trim(implode(' ', ['pxl-grid-item', $col_xxl, $col_xl, $col_lg, $col_md, $col_sm, $col_xs]));
          
        $loop = patholab_woocommerce_query($query_type,$post_per_page,$product_ids,$categories,$param_args);
        extract($loop);
        
        $data_animation = []; 
        $animate_cls = '';
        $data_settings = '';
        if ( !empty( $settings['item_animation'] ) ) {
            $animate_cls = ' pxl-animate pxl-invisible animated-'.$settings['item_animation_duration'];
            $data_animation['animation'] = $settings['item_animation'];
            $data_animation['animation_delay'] = $settings['item_animation_delay'];
        }
        if($posts->have_posts()){
            ob_start();
                $d = 0;
                while ($posts->have_posts()) {
                    $posts->the_post();
                    global $product;
                    $d++;
                    $term_list = array();
                    $term_of_post = wp_get_post_terms($product->get_ID(), 'product_cat');
                    foreach ($term_of_post as $term) {
                        $term_list[] = $term->slug;
                    }
                    $filter_class = implode(' ', $term_list);

                    if ( !empty( $data_animation ) ) { 
                        $data_animation['animation_delay'] = ((float)$settings['item_animation_delay'] * $d);
                        $data_animations = json_encode($data_animation);
                        $data_settings = 'data-settings="'.esc_attr($data_animations).'"';
                    }
                     
                    ?>
                    <div class="<?php echo trim(implode(' ', [$item_class, $filter_class, $animate_cls])); ?>" <?php pxl_print_html($data_settings); ?>>
                        <?php
                            do_action( 'woocommerce_before_shop_loop_item' );
                            do_action( 'woocommerce_before_shop_loop_item_title' );
                            do_action( 'woocommerce_shop_loop_item_title' );
                            do_action( 'woocommerce_after_shop_loop_item_title' );
                            do_action( 'woocommerce_after_shop_loop_item' );
                        ?>
                    </div>
                <?php 
                }
                if($settings['layout_mode'] == 'masonry')
                    echo '<div class="grid-sizer '.$item_class.'"></div>';
            $html = ob_get_clean();
            wp_send_json(
                array(
                    'status' => true,
                    'message' => esc_html__('Load Post Grid Successfully!', 'patholab'),
                    'data' => array(
                        'html'  => $html,
                        'paged' => $settings['paged'],
                        'posts' => $posts,
                        'max' => $max,
                    ),
                )
            );
        }else{
            wp_send_json(
                array(
                    'status' => false,
                    'message' => esc_html__('Load Post Grid No More!', 'patholab')
                )
            );
        } 
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}

add_action( 'wp_ajax_patholab_load_more_post_grid', 'patholab_load_more_post_grid' );
add_action( 'wp_ajax_nopriv_patholab_load_more_post_grid', 'patholab_load_more_post_grid' );
function patholab_load_more_post_grid(){
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'patholab'));
        }
        $settings = $_POST['settings'];
        set_query_var('paged', $settings['paged']);
        extract(pxl_get_posts_of_grid($settings['post_type'], [
            'source' => isset($settings['source'])?$settings['source']:'',
            'orderby' => isset($settings['orderby'])?$settings['orderby']:'date',
            'order' => isset($settings['order'])?$settings['order']:'desc',
            'limit' => isset($settings['limit'])?$settings['limit']:'6',
            'post_ids' => isset($settings['post_ids'])?$settings['post_ids']:[],
        ]));
        ob_start();
         
        patholab_get_post_grid($posts, $settings);
        $html = ob_get_clean();
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'patholab'),
                'data' => array(
                    'html' => $html,
                    'paged' => $settings['paged'],
                    'posts' => $posts,
                    'max' => $max,
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}